/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLogger {
    private static final boolean ok;
    private final String className;
    private final Logger logger;

    public ClassLogger(String subsystem, String className) {
        this.logger = ok ? LoggerFactory.getLogger((String)subsystem) : null;
        this.className = className;
    }

    public final boolean traceOn() {
        return this.finerOn();
    }

    public final boolean debugOn() {
        return this.finestOn();
    }

    public final boolean warningOn() {
        return ok && this.logger.isWarnEnabled();
    }

    public final boolean infoOn() {
        return ok && this.logger.isInfoEnabled();
    }

    public final boolean configOn() {
        return ok && this.logger.isInfoEnabled();
    }

    public final boolean fineOn() {
        return ok && this.logger.isDebugEnabled();
    }

    public final boolean finerOn() {
        return ok && this.logger.isDebugEnabled();
    }

    public final boolean finestOn() {
        return ok && this.logger.isDebugEnabled();
    }

    public final void debug(String func, String msg) {
        this.finest(func, msg);
    }

    public final void debug(String func, Throwable t2) {
        this.finest(func, t2);
    }

    public final void debug(String func, String msg, Throwable t2) {
        this.finest(func, msg, t2);
    }

    public final void trace(String func, String msg) {
        this.finer(func, msg);
    }

    public final void trace(String func, Throwable t2) {
        this.finer(func, t2);
    }

    public final void trace(String func, String msg, Throwable t2) {
        this.finer(func, msg, t2);
    }

    public final void error(String func, String msg) {
        this.severe(func, msg);
    }

    public final void error(String func, Throwable t2) {
        this.severe(func, t2);
    }

    public final void error(String func, String msg, Throwable t2) {
        this.severe(func, msg, t2);
    }

    public final void finest(String func, String msg) {
        if (ok) {
            this.logger.debug(this.className + "." + func + " - " + msg);
        }
    }

    public final void finest(String func, Throwable t2) {
        if (ok) {
            this.logger.debug(this.className + "." + func, t2);
        }
    }

    public final void finest(String func, String msg, Throwable t2) {
        if (ok) {
            this.logger.debug(this.className + "." + func + " - " + msg, t2);
        }
    }

    public final void finer(String func, String msg) {
        if (ok) {
            this.logger.debug(this.className + "." + func + " - " + msg);
        }
    }

    public final void finer(String func, Throwable t2) {
        if (ok) {
            this.logger.debug(this.className + "." + func, t2);
        }
    }

    public final void finer(String func, String msg, Throwable t2) {
        if (ok) {
            this.logger.debug(this.className + "." + func + " - " + msg, t2);
        }
    }

    public final void fine(String func, String msg) {
        if (ok) {
            this.logger.debug(this.className + "." + func + " - " + msg);
        }
    }

    public final void fine(String func, Throwable t2) {
        if (ok) {
            this.logger.debug(this.className + "." + func, t2);
        }
    }

    public final void fine(String func, String msg, Throwable t2) {
        if (ok) {
            this.logger.debug(this.className + "." + func + " - " + msg, t2);
        }
    }

    public final void config(String func, String msg) {
        if (ok) {
            this.logger.info(this.className + "." + func + " - " + msg);
        }
    }

    public final void config(String func, Throwable t2) {
        if (ok) {
            this.logger.info(this.className + "." + func, t2);
        }
    }

    public final void config(String func, String msg, Throwable t2) {
        if (ok) {
            this.logger.info(this.className + "." + func + " - " + msg, t2);
        }
    }

    public final void info(String func, String msg) {
        if (ok) {
            this.logger.info(this.className + "." + func + " - " + msg);
        }
    }

    public final void info(String func, Throwable t2) {
        if (ok) {
            this.logger.info(this.className + "." + func, t2);
        }
    }

    public final void info(String func, String msg, Throwable t2) {
        if (ok) {
            this.logger.info(this.className + "." + func + " - " + msg, t2);
        }
    }

    public final void warning(String func, String msg) {
        if (ok) {
            this.logger.warn(this.className + "." + func + " - " + msg);
        }
    }

    public final void warning(String func, Throwable t2) {
        if (ok) {
            this.logger.warn(this.className + "." + func, t2);
        }
    }

    public final void warning(String func, String msg, Throwable t2) {
        if (ok) {
            this.logger.warn(this.className + "." + func + " - " + msg, t2);
        }
    }

    public final void severe(String func, String msg) {
        if (ok) {
            this.logger.error(this.className + "." + func + " - " + msg);
        }
    }

    public final void severe(String func, Throwable t2) {
        if (ok) {
            this.logger.error(this.className + "." + func, t2);
        }
    }

    public final void severe(String func, String msg, Throwable t2) {
        if (ok) {
            this.logger.error(this.className + "." + func + " - " + msg, t2);
        }
    }

    static {
        boolean loaded = false;
        try {
            Class<Logger> c = Logger.class;
            loaded = true;
        }
        catch (Error error) {
            // empty catch block
        }
        ok = loaded;
    }
}

