/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxmetrics;

import io.opentelemetry.contrib.jmxmetrics.ConfigurationException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class JmxConfig {
    static final String PREFIX = "otel.";
    static final String SERVICE_URL = "otel.jmx.service.url";
    static final String GROOVY_SCRIPT = "otel.jmx.groovy.script";
    static final String TARGET_SYSTEM = "otel.jmx.target.system";
    static final String INTERVAL_MILLISECONDS = "otel.jmx.interval.milliseconds";
    static final String METRICS_EXPORTER_TYPE = "otel.metrics.exporter";
    static final String EXPORTER = "otel.exporter.";
    static final String REGISTRY_SSL = "otel.jmx.remote.registry.ssl";
    static final String EXPORTER_INTERVAL = "otel.metric.export.interval";
    static final String OTLP_ENDPOINT = "otel.exporter.otlp.endpoint";
    static final String PROMETHEUS_HOST = "otel.exporter.prometheus.host";
    static final String PROMETHEUS_PORT = "otel.exporter.prometheus.port";
    static final String JMX_USERNAME = "otel.jmx.username";
    static final String JMX_PASSWORD = "otel.jmx.password";
    static final String JMX_REMOTE_PROFILE = "otel.jmx.remote.profile";
    static final String JMX_REALM = "otel.jmx.realm";
    static final String JMX_AGGREGATE_ACROSS_MBEANS = "otel.jmx.aggregate.across.mbeans";
    static final List<String> JAVA_SYSTEM_PROPERTIES = Arrays.asList("javax.net.ssl.keyStore", "javax.net.ssl.keyStorePassword", "javax.net.ssl.keyStoreType", "javax.net.ssl.trustStore", "javax.net.ssl.trustStorePassword", "javax.net.ssl.trustStoreType");
    static final List<String> AVAILABLE_TARGET_SYSTEMS = Arrays.asList("activemq", "cassandra", "hbase", "hadoop", "jetty", "jvm", "kafka", "kafka-consumer", "kafka-producer", "solr", "tomcat", "wildfly");
    final String serviceUrl;
    final String groovyScript;
    final String targetSystem;
    final Set<String> targetSystems;
    final int intervalMilliseconds;
    final String metricsExporterType;
    final String otlpExporterEndpoint;
    final String prometheusExporterHost;
    final int prometheusExporterPort;
    final String username;
    final String password;
    final String realm;
    final String remoteProfile;
    final boolean registrySsl;
    final Properties properties = new Properties();
    final boolean aggregateAcrossMBeans;

    JmxConfig(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
        this.properties.putAll((Map<?, ?>)System.getProperties());
        this.serviceUrl = this.properties.getProperty(SERVICE_URL);
        this.groovyScript = this.properties.getProperty(GROOVY_SCRIPT);
        this.targetSystem = this.properties.getProperty(TARGET_SYSTEM, "").toLowerCase().trim();
        List<String> targets = Arrays.asList(JmxConfig.isBlank(this.targetSystem) ? new String[]{} : this.targetSystem.split(","));
        this.targetSystems = new LinkedHashSet<String>(targets);
        int interval = this.getProperty(INTERVAL_MILLISECONDS, 10000);
        this.intervalMilliseconds = interval == 0 ? 10000 : interval;
        this.getAndSetProperty(EXPORTER_INTERVAL, this.intervalMilliseconds);
        this.metricsExporterType = this.getAndSetProperty(METRICS_EXPORTER_TYPE, "logging");
        this.otlpExporterEndpoint = this.properties.getProperty(OTLP_ENDPOINT);
        this.prometheusExporterHost = this.getAndSetProperty(PROMETHEUS_HOST, "0.0.0.0");
        this.prometheusExporterPort = this.getAndSetProperty(PROMETHEUS_PORT, 9464);
        this.username = this.properties.getProperty(JMX_USERNAME);
        this.password = this.properties.getProperty(JMX_PASSWORD);
        this.remoteProfile = this.properties.getProperty(JMX_REMOTE_PROFILE);
        this.realm = this.properties.getProperty(JMX_REALM);
        this.registrySsl = Boolean.valueOf(this.properties.getProperty(REGISTRY_SSL));
        this.aggregateAcrossMBeans = Boolean.parseBoolean(this.properties.getProperty(JMX_AGGREGATE_ACROSS_MBEANS));
        JAVA_SYSTEM_PROPERTIES.forEach(key -> {
            if (System.getProperty(key) != null) {
                return;
            }
            String value = this.properties.getProperty((String)key);
            if (value != null) {
                System.setProperty(key, value);
            }
        });
    }

    JmxConfig() {
        this(new Properties());
    }

    private int getProperty(String key, int dfault) {
        String propVal = this.properties.getProperty(key);
        if (propVal == null) {
            return dfault;
        }
        try {
            return Integer.parseInt(propVal);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Failed to parse " + key, e);
        }
    }

    private String getAndSetProperty(String key, String defaultValue) {
        String propVal = this.properties.getProperty(key, defaultValue);
        if (propVal.equals(defaultValue)) {
            this.properties.setProperty(key, defaultValue);
        }
        return propVal;
    }

    private int getAndSetProperty(String key, int defaultValue) {
        int propVal = this.getProperty(key, defaultValue);
        if (propVal == defaultValue) {
            this.properties.setProperty(key, String.valueOf(defaultValue));
        }
        return propVal;
    }

    void validate() {
        if (JmxConfig.isBlank(this.serviceUrl)) {
            throw new ConfigurationException("otel.jmx.service.url must be specified.");
        }
        if (JmxConfig.isBlank(this.groovyScript) && JmxConfig.isBlank(this.targetSystem)) {
            throw new ConfigurationException("otel.jmx.groovy.script or otel.jmx.target.system must be specified.");
        }
        if (this.targetSystems.size() != 0 && !AVAILABLE_TARGET_SYSTEMS.containsAll(this.targetSystems)) {
            throw new ConfigurationException(String.format("%s must specify targets from %s", this.targetSystems, AVAILABLE_TARGET_SYSTEMS));
        }
        if (JmxConfig.isBlank(this.otlpExporterEndpoint) && !JmxConfig.isBlank(this.metricsExporterType) && this.metricsExporterType.equalsIgnoreCase("otlp")) {
            throw new ConfigurationException("otel.exporter.otlp.endpoint must be specified for otlp format.");
        }
        if (this.intervalMilliseconds < 0) {
            throw new ConfigurationException("otel.jmx.interval.milliseconds must be positive.");
        }
    }

    static boolean isBlank(String s2) {
        if (s2 == null) {
            return true;
        }
        return s2.trim().length() == 0;
    }
}

