/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.exporter.prometheus.PrometheusUnitsHelper;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.data.SummaryPointData;
import io.opentelemetry.sdk.metrics.data.ValueAtQuantile;
import io.opentelemetry.sdk.resources.Resource;
import io.prometheus.metrics.model.snapshots.ClassicHistogramBuckets;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.Exemplar;
import io.prometheus.metrics.model.snapshots.Exemplars;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.model.snapshots.InfoSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.NativeHistogramBuckets;
import io.prometheus.metrics.model.snapshots.PrometheusNaming;
import io.prometheus.metrics.model.snapshots.Quantile;
import io.prometheus.metrics.model.snapshots.Quantiles;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import io.prometheus.metrics.model.snapshots.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class Otel2PrometheusConverter {
    private static final Logger LOGGER = Logger.getLogger(Otel2PrometheusConverter.class.getName());
    private static final ThrottlingLogger THROTTLING_LOGGER = new ThrottlingLogger(LOGGER);
    private static final String OTEL_SCOPE_NAME = "otel_scope_name";
    private static final String OTEL_SCOPE_VERSION = "otel_scope_version";
    private static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    static final int MAX_CACHE_SIZE = 10;
    private final boolean otelScopeEnabled;
    @Nullable
    private final Predicate<String> allowedResourceAttributesFilter;
    private final Map<Attributes, List<AttributeKey<?>>> resourceAttributesToAllowedKeysCache;

    Otel2PrometheusConverter(boolean otelScopeEnabled, @Nullable Predicate<String> allowedResourceAttributesFilter) {
        this.otelScopeEnabled = otelScopeEnabled;
        this.allowedResourceAttributesFilter = allowedResourceAttributesFilter;
        this.resourceAttributesToAllowedKeysCache = allowedResourceAttributesFilter != null ? new ConcurrentHashMap() : Collections.emptyMap();
    }

    MetricSnapshots convert(@Nullable Collection<MetricData> metricDataCollection) {
        if (metricDataCollection == null || metricDataCollection.isEmpty()) {
            return MetricSnapshots.of(new MetricSnapshot[0]);
        }
        HashMap<String, MetricSnapshot> snapshotsByName = new HashMap<String, MetricSnapshot>(metricDataCollection.size());
        Resource resource = null;
        LinkedHashSet<InstrumentationScopeInfo> scopes = new LinkedHashSet<InstrumentationScopeInfo>();
        for (MetricData metricData : metricDataCollection) {
            MetricSnapshot snapshot = this.convert(metricData);
            if (snapshot == null) continue;
            Otel2PrometheusConverter.putOrMerge(snapshotsByName, snapshot);
            if (resource == null) {
                resource = metricData.getResource();
            }
            if (!this.otelScopeEnabled || metricData.getInstrumentationScopeInfo().getAttributes().isEmpty()) continue;
            scopes.add(metricData.getInstrumentationScopeInfo());
        }
        if (resource != null) {
            Otel2PrometheusConverter.putOrMerge(snapshotsByName, this.makeTargetInfo(resource));
        }
        if (this.otelScopeEnabled && !scopes.isEmpty()) {
            Otel2PrometheusConverter.putOrMerge(snapshotsByName, this.makeScopeInfo(scopes));
        }
        return new MetricSnapshots(snapshotsByName.values());
    }

    @Nullable
    private MetricSnapshot convert(MetricData metricData) {
        MetricMetadata metadata = Otel2PrometheusConverter.convertMetadata(metricData);
        InstrumentationScopeInfo scope = metricData.getInstrumentationScopeInfo();
        switch (metricData.getType()) {
            case LONG_GAUGE: {
                return this.convertLongGauge(metadata, scope, metricData.getLongGaugeData().getPoints(), metricData.getResource());
            }
            case DOUBLE_GAUGE: {
                return this.convertDoubleGauge(metadata, scope, metricData.getDoubleGaugeData().getPoints(), metricData.getResource());
            }
            case LONG_SUM: {
                SumData<LongPointData> longSumData = metricData.getLongSumData();
                if (longSumData.getAggregationTemporality() == AggregationTemporality.DELTA) {
                    return null;
                }
                if (longSumData.isMonotonic()) {
                    return this.convertLongCounter(metadata, scope, longSumData.getPoints(), metricData.getResource());
                }
                return this.convertLongGauge(metadata, scope, longSumData.getPoints(), metricData.getResource());
            }
            case DOUBLE_SUM: {
                SumData<DoublePointData> doubleSumData = metricData.getDoubleSumData();
                if (doubleSumData.getAggregationTemporality() == AggregationTemporality.DELTA) {
                    return null;
                }
                if (doubleSumData.isMonotonic()) {
                    return this.convertDoubleCounter(metadata, scope, doubleSumData.getPoints(), metricData.getResource());
                }
                return this.convertDoubleGauge(metadata, scope, doubleSumData.getPoints(), metricData.getResource());
            }
            case HISTOGRAM: {
                HistogramData histogramData = metricData.getHistogramData();
                if (histogramData.getAggregationTemporality() == AggregationTemporality.DELTA) {
                    return null;
                }
                return this.convertHistogram(metadata, scope, histogramData.getPoints(), metricData.getResource());
            }
            case EXPONENTIAL_HISTOGRAM: {
                ExponentialHistogramData exponentialHistogramData = metricData.getExponentialHistogramData();
                if (exponentialHistogramData.getAggregationTemporality() == AggregationTemporality.DELTA) {
                    return null;
                }
                return this.convertExponentialHistogram(metadata, scope, exponentialHistogramData.getPoints(), metricData.getResource());
            }
            case SUMMARY: {
                return this.convertSummary(metadata, scope, metricData.getSummaryData().getPoints(), metricData.getResource());
            }
        }
        return null;
    }

    private GaugeSnapshot convertLongGauge(MetricMetadata metadata, InstrumentationScopeInfo scope, Collection<LongPointData> dataPoints, Resource resource) {
        ArrayList<GaugeSnapshot.GaugeDataPointSnapshot> data = new ArrayList<GaugeSnapshot.GaugeDataPointSnapshot>(dataPoints.size());
        for (LongPointData longData : dataPoints) {
            data.add(new GaugeSnapshot.GaugeDataPointSnapshot(longData.getValue(), this.convertAttributes(resource, scope, longData.getAttributes(), new String[0]), this.convertLongExemplar(longData.getExemplars())));
        }
        return new GaugeSnapshot(metadata, (Collection<GaugeSnapshot.GaugeDataPointSnapshot>)data);
    }

    private CounterSnapshot convertLongCounter(MetricMetadata metadata, InstrumentationScopeInfo scope, Collection<LongPointData> dataPoints, Resource resource) {
        ArrayList<CounterSnapshot.CounterDataPointSnapshot> data = new ArrayList<CounterSnapshot.CounterDataPointSnapshot>(dataPoints.size());
        for (LongPointData longData : dataPoints) {
            data.add(new CounterSnapshot.CounterDataPointSnapshot(longData.getValue(), this.convertAttributes(resource, scope, longData.getAttributes(), new String[0]), this.convertLongExemplar(longData.getExemplars()), longData.getStartEpochNanos() / NANOS_PER_MILLISECOND));
        }
        return new CounterSnapshot(metadata, (Collection<CounterSnapshot.CounterDataPointSnapshot>)data);
    }

    private GaugeSnapshot convertDoubleGauge(MetricMetadata metadata, InstrumentationScopeInfo scope, Collection<DoublePointData> dataPoints, Resource resource) {
        ArrayList<GaugeSnapshot.GaugeDataPointSnapshot> data = new ArrayList<GaugeSnapshot.GaugeDataPointSnapshot>(dataPoints.size());
        for (DoublePointData doubleData : dataPoints) {
            data.add(new GaugeSnapshot.GaugeDataPointSnapshot(doubleData.getValue(), this.convertAttributes(resource, scope, doubleData.getAttributes(), new String[0]), this.convertDoubleExemplar(doubleData.getExemplars())));
        }
        return new GaugeSnapshot(metadata, (Collection<GaugeSnapshot.GaugeDataPointSnapshot>)data);
    }

    private CounterSnapshot convertDoubleCounter(MetricMetadata metadata, InstrumentationScopeInfo scope, Collection<DoublePointData> dataPoints, Resource resource) {
        ArrayList<CounterSnapshot.CounterDataPointSnapshot> data = new ArrayList<CounterSnapshot.CounterDataPointSnapshot>(dataPoints.size());
        for (DoublePointData doubleData : dataPoints) {
            data.add(new CounterSnapshot.CounterDataPointSnapshot(doubleData.getValue(), this.convertAttributes(resource, scope, doubleData.getAttributes(), new String[0]), this.convertDoubleExemplar(doubleData.getExemplars()), doubleData.getStartEpochNanos() / NANOS_PER_MILLISECOND));
        }
        return new CounterSnapshot(metadata, (Collection<CounterSnapshot.CounterDataPointSnapshot>)data);
    }

    private HistogramSnapshot convertHistogram(MetricMetadata metadata, InstrumentationScopeInfo scope, Collection<HistogramPointData> dataPoints, Resource resource) {
        ArrayList<HistogramSnapshot.HistogramDataPointSnapshot> data = new ArrayList<HistogramSnapshot.HistogramDataPointSnapshot>(dataPoints.size());
        for (HistogramPointData histogramData : dataPoints) {
            ArrayList<Double> boundaries = new ArrayList<Double>(histogramData.getBoundaries().size() + 1);
            boundaries.addAll(histogramData.getBoundaries());
            boundaries.add(Double.POSITIVE_INFINITY);
            data.add(new HistogramSnapshot.HistogramDataPointSnapshot(ClassicHistogramBuckets.of(boundaries, histogramData.getCounts()), histogramData.getSum(), this.convertAttributes(resource, scope, histogramData.getAttributes(), new String[0]), this.convertDoubleExemplars(histogramData.getExemplars()), histogramData.getStartEpochNanos() / NANOS_PER_MILLISECOND));
        }
        return new HistogramSnapshot(metadata, (Collection<HistogramSnapshot.HistogramDataPointSnapshot>)data);
    }

    @Nullable
    private HistogramSnapshot convertExponentialHistogram(MetricMetadata metadata, InstrumentationScopeInfo scope, Collection<ExponentialHistogramPointData> dataPoints, Resource resource) {
        ArrayList<HistogramSnapshot.HistogramDataPointSnapshot> data = new ArrayList<HistogramSnapshot.HistogramDataPointSnapshot>(dataPoints.size());
        for (ExponentialHistogramPointData histogramData : dataPoints) {
            int scale = histogramData.getScale();
            if (scale < -4) {
                THROTTLING_LOGGER.log(Level.WARNING, "Dropping histogram " + metadata.getName() + " with attributes " + histogramData.getAttributes() + " because it has scale < -4 which is unsupported in Prometheus");
                return null;
            }
            int scaleDown = scale > 8 ? scale - 8 : 0;
            data.add(new HistogramSnapshot.HistogramDataPointSnapshot(scale - scaleDown, histogramData.getZeroCount(), 0.0, Otel2PrometheusConverter.convertExponentialHistogramBuckets(histogramData.getPositiveBuckets(), scaleDown), Otel2PrometheusConverter.convertExponentialHistogramBuckets(histogramData.getNegativeBuckets(), scaleDown), histogramData.getSum(), this.convertAttributes(resource, scope, histogramData.getAttributes(), new String[0]), this.convertDoubleExemplars(histogramData.getExemplars()), histogramData.getStartEpochNanos() / NANOS_PER_MILLISECOND));
        }
        return new HistogramSnapshot(metadata, (Collection<HistogramSnapshot.HistogramDataPointSnapshot>)data);
    }

    private static NativeHistogramBuckets convertExponentialHistogramBuckets(ExponentialHistogramBuckets buckets, int scaleDown) {
        if (buckets.getBucketCounts().isEmpty()) {
            return NativeHistogramBuckets.EMPTY;
        }
        List<Long> otelCounts = buckets.getBucketCounts();
        ArrayList<Integer> indexes = new ArrayList<Integer>(otelCounts.size());
        ArrayList<Long> counts = new ArrayList<Long>(otelCounts.size());
        int previousIndex = (buckets.getOffset() >> scaleDown) + 1;
        long count = 0L;
        for (int i = 0; i < otelCounts.size(); ++i) {
            int index = (buckets.getOffset() + i >> scaleDown) + 1;
            if (index > previousIndex) {
                indexes.add(previousIndex);
                counts.add(count);
                previousIndex = index;
                count = 0L;
            }
            count += otelCounts.get(i).longValue();
        }
        indexes.add(previousIndex);
        counts.add(count);
        return NativeHistogramBuckets.of(indexes, counts);
    }

    private SummarySnapshot convertSummary(MetricMetadata metadata, InstrumentationScopeInfo scope, Collection<SummaryPointData> dataPoints, Resource resource) {
        ArrayList<SummarySnapshot.SummaryDataPointSnapshot> data = new ArrayList<SummarySnapshot.SummaryDataPointSnapshot>(dataPoints.size());
        for (SummaryPointData summaryData : dataPoints) {
            data.add(new SummarySnapshot.SummaryDataPointSnapshot(summaryData.getCount(), summaryData.getSum(), Otel2PrometheusConverter.convertQuantiles(summaryData.getValues()), this.convertAttributes(resource, scope, summaryData.getAttributes(), new String[0]), Exemplars.EMPTY, summaryData.getStartEpochNanos() / NANOS_PER_MILLISECOND));
        }
        return new SummarySnapshot(metadata, (Collection<SummarySnapshot.SummaryDataPointSnapshot>)data);
    }

    private static Quantiles convertQuantiles(List<ValueAtQuantile> values2) {
        ArrayList<Quantile> result = new ArrayList<Quantile>(values2.size());
        for (ValueAtQuantile value : values2) {
            result.add(new Quantile(value.getQuantile(), value.getValue()));
        }
        return Quantiles.of(result);
    }

    @Nullable
    private Exemplar convertLongExemplar(List<LongExemplarData> exemplars) {
        if (exemplars.isEmpty()) {
            return null;
        }
        LongExemplarData exemplar = exemplars.get(0);
        return this.convertExemplar(exemplar.getValue(), exemplar);
    }

    @Nullable
    private Exemplar convertDoubleExemplar(List<DoubleExemplarData> exemplars) {
        if (exemplars.isEmpty()) {
            return null;
        }
        DoubleExemplarData exemplar = exemplars.get(0);
        return this.convertExemplar(exemplar.getValue(), exemplar);
    }

    private Exemplars convertDoubleExemplars(List<DoubleExemplarData> exemplars) {
        ArrayList<Exemplar> result = new ArrayList<Exemplar>(exemplars.size());
        for (DoubleExemplarData exemplar : exemplars) {
            result.add(this.convertExemplar(exemplar.getValue(), exemplar));
        }
        return Exemplars.of(result);
    }

    private Exemplar convertExemplar(double value, ExemplarData exemplar) {
        SpanContext spanContext = exemplar.getSpanContext();
        if (spanContext.isValid()) {
            return new Exemplar(value, this.convertAttributes(null, null, exemplar.getFilteredAttributes(), "trace_id", spanContext.getTraceId(), "span_id", spanContext.getSpanId()), exemplar.getEpochNanos() / NANOS_PER_MILLISECOND);
        }
        return new Exemplar(value, this.convertAttributes(null, null, exemplar.getFilteredAttributes(), new String[0]), exemplar.getEpochNanos() / NANOS_PER_MILLISECOND);
    }

    private InfoSnapshot makeTargetInfo(Resource resource) {
        return new InfoSnapshot(new MetricMetadata("target"), (Collection<InfoSnapshot.InfoDataPointSnapshot>)Collections.singletonList(new InfoSnapshot.InfoDataPointSnapshot(this.convertAttributes(null, null, resource.getAttributes(), new String[0]))));
    }

    private InfoSnapshot makeScopeInfo(Set<InstrumentationScopeInfo> scopes) {
        ArrayList<InfoSnapshot.InfoDataPointSnapshot> prometheusScopeInfos = new ArrayList<InfoSnapshot.InfoDataPointSnapshot>(scopes.size());
        for (InstrumentationScopeInfo scope : scopes) {
            prometheusScopeInfos.add(new InfoSnapshot.InfoDataPointSnapshot(this.convertAttributes(null, scope, scope.getAttributes(), new String[0])));
        }
        return new InfoSnapshot(new MetricMetadata("otel_scope"), (Collection<InfoSnapshot.InfoDataPointSnapshot>)prometheusScopeInfos);
    }

    private Labels convertAttributes(@Nullable Resource resource, @Nullable InstrumentationScopeInfo scope, Attributes attributes, String ... additionalAttributes) {
        List<AttributeKey> allowedAttributeKeys = this.allowedResourceAttributesFilter != null ? this.filterAllowedResourceAttributeKeys(resource) : Collections.emptyList();
        HashMap<String, String> labelNameToValue = new HashMap<String, String>();
        attributes.forEach((key, value) -> labelNameToValue.put(PrometheusNaming.sanitizeLabelName(key.getKey()), value.toString()));
        for (int i = 0; i < additionalAttributes.length; i += 2) {
            labelNameToValue.putIfAbsent(Objects.requireNonNull(additionalAttributes[i]), additionalAttributes[i + 1]);
        }
        if (this.otelScopeEnabled && scope != null) {
            labelNameToValue.putIfAbsent(OTEL_SCOPE_NAME, scope.getName());
            if (scope.getVersion() != null) {
                labelNameToValue.putIfAbsent(OTEL_SCOPE_VERSION, scope.getVersion());
            }
        }
        if (resource != null) {
            Attributes resourceAttributes = resource.getAttributes();
            for (AttributeKey attributeKey : allowedAttributeKeys) {
                Object attributeValue = resourceAttributes.get(attributeKey);
                if (attributeValue == null) continue;
                labelNameToValue.putIfAbsent(PrometheusNaming.sanitizeLabelName(attributeKey.getKey()), attributeValue.toString());
            }
        }
        String[] names = new String[labelNameToValue.size()];
        String[] values2 = new String[labelNameToValue.size()];
        int[] pos = new int[]{0};
        labelNameToValue.forEach((name, value) -> {
            names[pos[0]] = name;
            values2[pos[0]] = value;
            pos[0] = pos[0] + 1;
        });
        return Labels.of(names, values2);
    }

    private List<AttributeKey<?>> filterAllowedResourceAttributeKeys(@Nullable Resource resource) {
        Objects.requireNonNull(this.allowedResourceAttributesFilter, "This method should only be called when allowedResourceAttributesFilter is not null.");
        if (resource == null) {
            return Collections.emptyList();
        }
        List allowedAttributeKeys = this.resourceAttributesToAllowedKeysCache.computeIfAbsent(resource.getAttributes(), resourceAttributes -> resourceAttributes.asMap().keySet().stream().filter(o -> this.allowedResourceAttributesFilter.test(o.getKey())).collect(Collectors.toList()));
        if (this.resourceAttributesToAllowedKeysCache.size() > 10) {
            this.resourceAttributesToAllowedKeysCache.clear();
        }
        return allowedAttributeKeys;
    }

    private static MetricMetadata convertMetadata(MetricData metricData) {
        String name = PrometheusNaming.sanitizeMetricName(metricData.getName());
        String help = metricData.getDescription();
        Unit unit = PrometheusUnitsHelper.convertUnit(metricData.getUnit());
        if (unit != null && !name.endsWith(unit.toString())) {
            name = name + "_" + unit;
        }
        while (name.contains("__")) {
            name = name.replace("__", "_");
        }
        return new MetricMetadata(name, help, unit);
    }

    private static void putOrMerge(Map<String, MetricSnapshot> snapshotsByName, MetricSnapshot snapshot) {
        String name = snapshot.getMetadata().getPrometheusName();
        if (snapshotsByName.containsKey(name)) {
            MetricSnapshot merged = Otel2PrometheusConverter.merge(snapshotsByName.get(name), snapshot);
            if (merged != null) {
                snapshotsByName.put(name, merged);
            }
        } else {
            snapshotsByName.put(name, snapshot);
        }
    }

    @Nullable
    private static MetricSnapshot merge(MetricSnapshot a, MetricSnapshot b) {
        MetricMetadata metadata = Otel2PrometheusConverter.mergeMetadata(a.getMetadata(), b.getMetadata());
        if (metadata == null) {
            return null;
        }
        int numberOfDataPoints = a.getDataPoints().size() + b.getDataPoints().size();
        if (a instanceof GaugeSnapshot && b instanceof GaugeSnapshot) {
            ArrayList<GaugeSnapshot.GaugeDataPointSnapshot> dataPoints = new ArrayList<GaugeSnapshot.GaugeDataPointSnapshot>(numberOfDataPoints);
            dataPoints.addAll(((GaugeSnapshot)a).getDataPoints());
            dataPoints.addAll(((GaugeSnapshot)b).getDataPoints());
            return new GaugeSnapshot(metadata, (Collection<GaugeSnapshot.GaugeDataPointSnapshot>)dataPoints);
        }
        if (a instanceof CounterSnapshot && b instanceof CounterSnapshot) {
            ArrayList<CounterSnapshot.CounterDataPointSnapshot> dataPoints = new ArrayList<CounterSnapshot.CounterDataPointSnapshot>(numberOfDataPoints);
            dataPoints.addAll(((CounterSnapshot)a).getDataPoints());
            dataPoints.addAll(((CounterSnapshot)b).getDataPoints());
            return new CounterSnapshot(metadata, (Collection<CounterSnapshot.CounterDataPointSnapshot>)dataPoints);
        }
        if (a instanceof HistogramSnapshot && b instanceof HistogramSnapshot) {
            ArrayList<HistogramSnapshot.HistogramDataPointSnapshot> dataPoints = new ArrayList<HistogramSnapshot.HistogramDataPointSnapshot>(numberOfDataPoints);
            dataPoints.addAll(((HistogramSnapshot)a).getDataPoints());
            dataPoints.addAll(((HistogramSnapshot)b).getDataPoints());
            return new HistogramSnapshot(metadata, (Collection<HistogramSnapshot.HistogramDataPointSnapshot>)dataPoints);
        }
        if (a instanceof SummarySnapshot && b instanceof SummarySnapshot) {
            ArrayList<SummarySnapshot.SummaryDataPointSnapshot> dataPoints = new ArrayList<SummarySnapshot.SummaryDataPointSnapshot>(numberOfDataPoints);
            dataPoints.addAll(((SummarySnapshot)a).getDataPoints());
            dataPoints.addAll(((SummarySnapshot)b).getDataPoints());
            return new SummarySnapshot(metadata, (Collection<SummarySnapshot.SummaryDataPointSnapshot>)dataPoints);
        }
        if (a instanceof InfoSnapshot && b instanceof InfoSnapshot) {
            ArrayList<InfoSnapshot.InfoDataPointSnapshot> dataPoints = new ArrayList<InfoSnapshot.InfoDataPointSnapshot>(numberOfDataPoints);
            dataPoints.addAll(((InfoSnapshot)a).getDataPoints());
            dataPoints.addAll(((InfoSnapshot)b).getDataPoints());
            return new InfoSnapshot(metadata, (Collection<InfoSnapshot.InfoDataPointSnapshot>)dataPoints);
        }
        THROTTLING_LOGGER.log(Level.WARNING, "Conflicting metric name " + a.getMetadata().getPrometheusName() + ": Found one metric with type " + Otel2PrometheusConverter.typeString(a) + " and one of type " + Otel2PrometheusConverter.typeString(b) + ". Dropping the one with type " + Otel2PrometheusConverter.typeString(b) + ".");
        return null;
    }

    @Nullable
    private static MetricMetadata mergeMetadata(MetricMetadata a, MetricMetadata b) {
        Unit unit;
        String name = a.getPrometheusName();
        if (a.getName().equals(b.getName())) {
            name = a.getName();
        }
        String help = null;
        if (a.getHelp() != null && a.getHelp().equals(b.getHelp())) {
            help = a.getHelp();
        }
        if ((unit = a.getUnit()) != null && !unit.equals(b.getUnit())) {
            THROTTLING_LOGGER.log(Level.WARNING, "Conflicting metrics: Multiple metrics with name " + name + " but different units found. Dropping the one with unit " + b.getUnit() + ".");
            return null;
        }
        return new MetricMetadata(name, help, unit);
    }

    private static String typeString(MetricSnapshot snapshot) {
        return snapshot.getClass().getSimpleName().replace("Snapshot", "").toLowerCase(Locale.ENGLISH);
    }
}

