/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import com.sun.net.httpserver.HttpHandler;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusMetricReader;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.prometheus.metrics.exporter.httpserver.HTTPServer;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class PrometheusHttpServer
implements MetricReader {
    private final PrometheusHttpServerBuilder builder;
    private final HTTPServer httpServer;
    private final PrometheusMetricReader prometheusMetricReader;
    private final PrometheusRegistry prometheusRegistry;
    private final String host;
    private final MemoryMode memoryMode;
    private final DefaultAggregationSelector defaultAggregationSelector;

    public static PrometheusHttpServer create() {
        return PrometheusHttpServer.builder().build();
    }

    public static PrometheusHttpServerBuilder builder() {
        return new PrometheusHttpServerBuilder();
    }

    PrometheusHttpServer(PrometheusHttpServerBuilder builder, String host, int port, @Nullable ExecutorService executor, PrometheusRegistry prometheusRegistry, boolean otelScopeEnabled, @Nullable Predicate<String> allowedResourceAttributesFilter, MemoryMode memoryMode, @Nullable HttpHandler defaultHandler, DefaultAggregationSelector defaultAggregationSelector) {
        this.builder = builder;
        this.prometheusMetricReader = new PrometheusMetricReader(otelScopeEnabled, allowedResourceAttributesFilter);
        this.host = host;
        this.memoryMode = memoryMode;
        this.prometheusRegistry = prometheusRegistry;
        prometheusRegistry.register(this.prometheusMetricReader);
        if (memoryMode == MemoryMode.REUSABLE_DATA) {
            executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("prometheus-http-server"));
        }
        try {
            this.httpServer = HTTPServer.builder().hostname(host).port(port).executorService(executor).registry(prometheusRegistry).defaultHandler(defaultHandler).buildAndStart();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not create Prometheus HTTP server", e);
        }
        this.defaultAggregationSelector = defaultAggregationSelector;
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.prometheusMetricReader.getAggregationTemporality(instrumentType);
    }

    @Override
    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    @Override
    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    @Override
    public void register(CollectionRegistration registration) {
        this.prometheusMetricReader.register(registration);
    }

    @Override
    public CompletableResultCode forceFlush() {
        return this.prometheusMetricReader.forceFlush();
    }

    @Override
    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        Runnable shutdownFunction = () -> {
            try {
                this.prometheusRegistry.unregister(this.prometheusMetricReader);
                this.httpServer.stop();
                this.prometheusMetricReader.shutdown().whenComplete(result::succeed);
            }
            catch (Throwable t2) {
                result.fail();
            }
        };
        Thread shutdownThread = new Thread(shutdownFunction, "prometheus-httpserver-shutdown");
        shutdownThread.setDaemon(true);
        shutdownThread.start();
        return result;
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "PrometheusHttpServer{address=" + this.getAddress() + "}";
    }

    public PrometheusHttpServerBuilder toBuilder() {
        return new PrometheusHttpServerBuilder(this.builder);
    }

    InetSocketAddress getAddress() {
        return new InetSocketAddress(this.host, this.httpServer.getPort());
    }
}

