/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus.internal;

import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConfigurableMetricReaderProvider;
import io.opentelemetry.sdk.metrics.export.MetricReader;

public class PrometheusMetricReaderProvider
implements ConfigurableMetricReaderProvider {
    @Override
    public MetricReader createMetricReader(ConfigProperties config) {
        String host;
        PrometheusHttpServerBuilder prometheusBuilder = PrometheusHttpServer.builder();
        Integer port = config.getInt("otel.exporter.prometheus.port");
        if (port != null) {
            prometheusBuilder.setPort(port);
        }
        if ((host = config.getString("otel.exporter.prometheus.host")) != null) {
            prometheusBuilder.setHost(host);
        }
        ExporterBuilderUtil.configureExporterMemoryMode(config, prometheusBuilder::setMemoryMode);
        String defaultHistogramAggregation = config.getString("otel.java.experimental.exporter.prometheus.metrics.default.histogram.aggregation");
        if (defaultHistogramAggregation != null) {
            ExporterBuilderUtil.configureHistogramDefaultAggregation(defaultHistogramAggregation, prometheusBuilder::setDefaultAggregationSelector);
        }
        return prometheusBuilder.build();
    }

    @Override
    public String getName() {
        return "prometheus";
    }
}

