/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.time;

import io.opentelemetry.sdk.common.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TestClock
implements Clock {
    private long currentEpochNanos;

    private TestClock(long epochNanos) {
        this.currentEpochNanos = epochNanos;
    }

    public static TestClock create() {
        return TestClock.create(Instant.ofEpochMilli(1557212400000L));
    }

    public static TestClock create(Instant instant) {
        return new TestClock(TestClock.toNanos(instant));
    }

    public synchronized void setTime(Instant instant) {
        this.currentEpochNanos = TestClock.toNanos(instant);
    }

    public synchronized void advance(Duration duration) {
        this.advance(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public synchronized void advance(long duration, TimeUnit unit) {
        this.currentEpochNanos += unit.toNanos(duration);
    }

    @Override
    public synchronized long now() {
        return this.currentEpochNanos;
    }

    @Override
    public synchronized long nanoTime() {
        return this.currentEpochNanos;
    }

    private static long toNanos(Instant instant) {
        return TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
    }
}

