/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.exporter.otlp.internal.CodedOutputStream;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.ProtoFieldInfo;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ProtoSerializer
extends Serializer
implements AutoCloseable {
    private static final ThreadLocal<Map<String, byte[]>> THREAD_LOCAL_ID_CACHE = new ThreadLocal();
    private final CodedOutputStream output;
    private final Map<String, byte[]> idCache;

    ProtoSerializer(OutputStream output) {
        this.output = CodedOutputStream.newInstance(output);
        this.idCache = ProtoSerializer.getIdCache();
    }

    @Override
    protected void writeTraceId(ProtoFieldInfo field, String traceId) throws IOException {
        byte[] traceIdBytes = this.idCache.computeIfAbsent(traceId, id -> OtelEncodingUtils.bytesFromBase16(id, TraceId.getLength()));
        this.writeBytes(field, traceIdBytes);
    }

    @Override
    protected void writeSpanId(ProtoFieldInfo field, String spanId) throws IOException {
        byte[] spanIdBytes = this.idCache.computeIfAbsent(spanId, id -> OtelEncodingUtils.bytesFromBase16(id, SpanId.getLength()));
        this.writeBytes(field, spanIdBytes);
    }

    @Override
    protected void writeBool(ProtoFieldInfo field, boolean value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeBoolNoTag(value);
    }

    @Override
    protected void writeEnum(ProtoFieldInfo field, int enumNumber) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeEnumNoTag(enumNumber);
    }

    @Override
    protected void writeUint32(ProtoFieldInfo field, int value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeUInt32NoTag(value);
    }

    @Override
    protected void writeInt64(ProtoFieldInfo field, long value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeInt64NoTag(value);
    }

    @Override
    protected void writeFixed64(ProtoFieldInfo field, long value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeFixed64NoTag(value);
    }

    @Override
    protected void writeFixed64Value(long value) throws IOException {
        this.output.writeFixed64NoTag(value);
    }

    @Override
    protected void writeDouble(ProtoFieldInfo field, double value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeDoubleNoTag(value);
    }

    @Override
    protected void writeDoubleValue(double value) throws IOException {
        this.output.writeDoubleNoTag(value);
    }

    @Override
    protected void writeString(ProtoFieldInfo field, byte[] utf8Bytes) throws IOException {
        this.writeBytes(field, utf8Bytes);
    }

    @Override
    protected void writeBytes(ProtoFieldInfo field, byte[] value) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeByteArrayNoTag(value);
    }

    @Override
    protected void writeStartMessage(ProtoFieldInfo field, int protoMessageSize) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeUInt32NoTag(protoMessageSize);
    }

    @Override
    protected void writeEndMessage() {
    }

    @Override
    protected void writeStartRepeatedPrimitive(ProtoFieldInfo field, int protoSizePerElement, int numElements) throws IOException {
        this.output.writeUInt32NoTag(field.getTag());
        this.output.writeUInt32NoTag(protoSizePerElement * numElements);
    }

    @Override
    protected void writeEndRepeatedPrimitive() {
    }

    @Override
    public void serializeRepeatedMessage(ProtoFieldInfo field, Marshaler[] repeatedMessage) throws IOException {
        for (Marshaler message : repeatedMessage) {
            this.serializeMessage(field, message);
        }
    }

    @Override
    public void serializeRepeatedMessage(ProtoFieldInfo field, List<? extends Marshaler> repeatedMessage) throws IOException {
        for (Marshaler marshaler : repeatedMessage) {
            this.serializeMessage(field, marshaler);
        }
    }

    @Override
    public void writeSerializedMessage(byte[] protoSerialized, byte[] jsonSerialized) throws IOException {
        this.output.writeRawBytes(protoSerialized);
    }

    @Override
    public void close() throws IOException {
        this.output.flush();
        this.idCache.clear();
    }

    private static Map<String, byte[]> getIdCache() {
        Map<String, byte[]> result = THREAD_LOCAL_ID_CACHE.get();
        if (result == null) {
            result = new HashMap<String, byte[]>();
            THREAD_LOCAL_ID_CACHE.set(result);
        }
        return result;
    }
}

