/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import io.opentelemetry.exporter.otlp.internal.KeyValueMarshaler;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.MarshalerUtil;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.ProtoFieldInfo;
import io.opentelemetry.exporter.otlp.internal.ProtoSerializer;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import io.opentelemetry.sdk.resources.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

final class ResourceMarshaler
extends MarshalerWithSize {
    private static final WeakConcurrentMap<Resource, ResourceMarshaler> RESOURCE_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction<Resource, ResourceMarshaler>();
    private final byte[] serializedResource;

    static ResourceMarshaler create(Resource resource) {
        ResourceMarshaler cached = (ResourceMarshaler)RESOURCE_MARSHALER_CACHE.get((Object)resource);
        if (cached == null) {
            cached = new ResourceMarshaler(KeyValueMarshaler.createRepeated(resource.getAttributes()));
            RESOURCE_MARSHALER_CACHE.put((Object)resource, (Object)cached);
        }
        return cached;
    }

    private ResourceMarshaler(KeyValueMarshaler[] attributeMarshalers) {
        super(ResourceMarshaler.calculateSize(attributeMarshalers));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.getBinarySerializedSize());
        try (ProtoSerializer serializer = new ProtoSerializer(bos);){
            serializer.serializeRepeatedMessage(io.opentelemetry.proto.resource.v1.internal.Resource.ATTRIBUTES, attributeMarshalers);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.serializedResource = bos.toByteArray();
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeSerializedMessage(this.serializedResource, MarshalerUtil.EMPTY_BYTES);
    }

    private static int calculateSize(KeyValueMarshaler[] attributeMarshalers) {
        return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)io.opentelemetry.proto.resource.v1.internal.Resource.ATTRIBUTES, (Marshaler[])attributeMarshalers);
    }
}

