/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.maven.OtelUtils;
import io.opentelemetry.maven.StringUtils;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=OpenTelemetrySdkService.class, hint="opentelemetry-service")
public final class OpenTelemetrySdkService
implements Initializable,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetrySdkService.class);
    @Requirement
    private RuntimeInformation runtimeInformation;
    private OpenTelemetrySdk openTelemetrySdk;
    private Tracer tracer;
    private SpanExporter spanExporter;

    public synchronized void dispose() {
        logger.debug("OpenTelemetry: dispose OpenTelemetrySdkService...");
        if (this.openTelemetrySdk != null) {
            logger.debug("OpenTelemetry: Shutdown SDK Trace Provider...");
            CompletableResultCode sdkProviderShutdown = this.openTelemetrySdk.getSdkTracerProvider().shutdown();
            sdkProviderShutdown.join(10L, TimeUnit.SECONDS);
            if (sdkProviderShutdown.isSuccess()) {
                logger.debug("OpenTelemetry: SDK Trace Provider shut down");
            } else {
                logger.warn("OpenTelemetry: Failure to shutdown SDK Trace Provider (done: " + sdkProviderShutdown.isDone() + ")");
            }
            GlobalOpenTelemetry.resetForTest();
            this.openTelemetrySdk = null;
        }
        logger.debug("OpenTelemetry: OpenTelemetrySdkService disposed");
    }

    public void initialize() throws InitializationException {
        logger.debug("OpenTelemetry: initialize OpenTelemetrySdkService...");
        String otlpEndpoint = System.getProperty("otel.exporter.otlp.endpoint", System.getenv("OTEL_EXPORTER_OTLP_ENDPOINT"));
        if (StringUtils.isBlank(otlpEndpoint)) {
            logger.debug("OpenTelemetry: No -Dotel.exporter.otlp.endpoint property or OTEL_EXPORTER_OTLP_ENDPOINT environment variable found, use a NOOP tracer");
            GlobalOpenTelemetry.set(OpenTelemetry.noop());
        } else {
            OtlpGrpcSpanExporterBuilder spanExporterBuilder = OtlpGrpcSpanExporter.builder();
            spanExporterBuilder.setEndpoint(otlpEndpoint);
            String otlpExporterHeadersAsString = System.getProperty("otel.exporter.otlp.headers", System.getenv("OTEL_EXPORTER_OTLP_HEADERS"));
            Map<String, String> otlpExporterHeaders = OtelUtils.getCommaSeparatedMap(otlpExporterHeadersAsString);
            otlpExporterHeaders.forEach(spanExporterBuilder::addHeader);
            String otlpExporterTimeoutMillis = System.getProperty("otel.exporter.otlp.timeout", System.getenv("OTEL_EXPORTER_OTLP_TIMEOUT"));
            if (StringUtils.isNotBlank(otlpExporterTimeoutMillis)) {
                try {
                    spanExporterBuilder.setTimeout(Duration.ofMillis(Long.parseLong(otlpExporterTimeoutMillis)));
                }
                catch (NumberFormatException e) {
                    logger.warn("OpenTelemetry: Skip invalid OTLP timeout " + otlpExporterTimeoutMillis, (Throwable)e);
                }
            }
            this.spanExporter = spanExporterBuilder.build();
            AttributesBuilder resourceAttributesBuilder = Attributes.builder();
            Resource mavenResource = this.getMavenResource();
            resourceAttributesBuilder.putAll(mavenResource.getAttributes());
            String otelResourceAttributesAsString = System.getProperty("otel.resource.attributes", System.getenv("OTEL_RESOURCE_ATTRIBUTES"));
            if (StringUtils.isNotBlank(otelResourceAttributesAsString)) {
                Map<String, String> otelResourceAttributes = OtelUtils.getCommaSeparatedMap(otelResourceAttributesAsString);
                otelResourceAttributes.forEach(resourceAttributesBuilder::put);
            }
            Attributes resourceAttributes = resourceAttributesBuilder.build();
            logger.debug("OpenTelemetry: Export OpenTelemetry traces to {} with attributes: {}", (Object)otlpEndpoint, (Object)resourceAttributes);
            BatchSpanProcessor batchSpanProcessor = BatchSpanProcessor.builder(this.spanExporter).build();
            SdkTracerProvider sdkTracerProvider = SdkTracerProvider.builder().setResource(Resource.create(resourceAttributes)).addSpanProcessor(batchSpanProcessor).build();
            this.openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(ContextPropagators.create(W3CTraceContextPropagator.getInstance())).buildAndRegisterGlobal();
        }
        this.tracer = GlobalOpenTelemetry.getTracer("io.opentelemetry.contrib.maven");
    }

    public Tracer getTracer() {
        if (this.tracer == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.tracer;
    }

    protected Resource getMavenResource() {
        String mavenVersion = this.runtimeInformation.getMavenVersion();
        Attributes attributes = Attributes.of(ResourceAttributes.SERVICE_NAME, "maven", ResourceAttributes.SERVICE_VERSION, mavenVersion);
        return Resource.create(attributes);
    }

    public ContextPropagators getPropagators() {
        return this.openTelemetrySdk.getPropagators();
    }
}

