/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.maven.ChainedExecutionListener;
import io.opentelemetry.maven.OpenTelemetrySdkService;
import io.opentelemetry.maven.SpanRegistry;
import io.opentelemetry.maven.semconv.MavenOtelSemanticAttributes;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ExecutionListener.class, hint="otel-execution-listener")
public final class OtelExecutionListener
extends AbstractExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(OtelExecutionListener.class);
    @Requirement
    private SpanRegistry spanRegistry;
    @Requirement
    private OpenTelemetrySdkService openTelemetrySdkService;

    public static void registerOtelExecutionListener(MavenSession session, OtelExecutionListener otelExecutionListener) {
        ExecutionListener initialExecutionListener = session.getRequest().getExecutionListener();
        if (initialExecutionListener instanceof ChainedExecutionListener || initialExecutionListener instanceof OtelExecutionListener) {
            logger.debug("OpenTelemetry: OpenTelemetry extension already registered as execution listener, skip.");
        } else if (initialExecutionListener == null) {
            session.getRequest().setExecutionListener((ExecutionListener)otelExecutionListener);
            logger.debug("OpenTelemetry: OpenTelemetry extension registered as execution listener. No execution listener initially defined");
        } else {
            session.getRequest().setExecutionListener((ExecutionListener)new ChainedExecutionListener(new ExecutionListener[]{otelExecutionListener, initialExecutionListener}));
            logger.debug("OpenTelemetry: OpenTelemetry extension registered as execution listener. InitialExecutionListener: " + initialExecutionListener);
        }
    }

    public void sessionStarted(ExecutionEvent executionEvent) {
        MavenProject project = executionEvent.getSession().getTopLevelProject();
        ToUpperCaseTextMapGetter toUpperCaseTextMapGetter = new ToUpperCaseTextMapGetter();
        Context context = this.openTelemetrySdkService.getPropagators().getTextMapPropagator().extract(Context.current(), System.getenv(), toUpperCaseTextMapGetter);
        String spanName = "Build: " + project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion();
        logger.debug("OpenTelemetry: Start session span: {}", (Object)spanName);
        Span sessionSpan = this.openTelemetrySdkService.getTracer().spanBuilder(spanName).setParent(context).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_GROUP_ID, project.getGroupId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_ARTIFACT_ID, project.getArtifactId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_VERSION, project.getVersion()).startSpan();
        this.spanRegistry.setRootSpan(sessionSpan);
    }

    public void projectStarted(ExecutionEvent executionEvent) {
        MavenProject project = executionEvent.getProject();
        String spanName = project.getGroupId() + ":" + project.getArtifactId();
        logger.debug("OpenTelemetry: Start project span: {}", (Object)spanName);
        Span rootSpan = this.spanRegistry.getRootSpanNotNull();
        Tracer tracer = this.openTelemetrySdkService.getTracer();
        Span projectSpan = tracer.spanBuilder(spanName).setParent(Context.current().with(Span.wrap(rootSpan.getSpanContext()))).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_GROUP_ID, project.getGroupId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_ARTIFACT_ID, project.getArtifactId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_VERSION, project.getVersion()).startSpan();
        this.spanRegistry.putSpan(projectSpan, project);
    }

    public void projectSucceeded(ExecutionEvent executionEvent) {
        logger.debug("OpenTelemetry: End succeeded project span: {}:{}", (Object)executionEvent.getProject().getArtifactId(), (Object)executionEvent.getProject().getArtifactId());
        this.spanRegistry.removeSpan(executionEvent.getProject()).end();
    }

    public void projectFailed(ExecutionEvent executionEvent) {
        logger.debug("OpenTelemetry: End failed project span: {}:{}", (Object)executionEvent.getProject().getArtifactId(), (Object)executionEvent.getProject().getArtifactId());
        Span span = this.spanRegistry.removeSpan(executionEvent.getProject());
        span.setStatus(StatusCode.ERROR);
        span.recordException(executionEvent.getException());
        span.end();
    }

    public void mojoStarted(ExecutionEvent executionEvent) {
        MojoExecution mojoExecution = executionEvent.getMojoExecution();
        Span rootSpan = this.spanRegistry.getSpan(executionEvent.getProject());
        String spanName = this.getPluginArtifactIdShortName(mojoExecution.getArtifactId()) + ":" + mojoExecution.getGoal() + " (" + executionEvent.getMojoExecution().getExecutionId() + ") @ " + executionEvent.getProject().getArtifactId();
        logger.debug("OpenTelemetry: Start mojo execution: span {}", (Object)spanName);
        Span span = this.openTelemetrySdkService.getTracer().spanBuilder(spanName).setParent(Context.current().with(Span.wrap(rootSpan.getSpanContext()))).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_GROUP_ID, executionEvent.getProject().getGroupId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_ARTIFACT_ID, executionEvent.getProject().getArtifactId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PROJECT_VERSION, executionEvent.getProject().getVersion()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PLUGIN_GROUP_ID, mojoExecution.getPlugin().getGroupId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PLUGIN_ARTIFACT_ID, mojoExecution.getPlugin().getArtifactId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_PLUGIN_VERSION, mojoExecution.getPlugin().getVersion()).setAttribute(MavenOtelSemanticAttributes.MAVEN_EXECUTION_GOAL, mojoExecution.getGoal()).setAttribute(MavenOtelSemanticAttributes.MAVEN_EXECUTION_ID, mojoExecution.getExecutionId()).setAttribute(MavenOtelSemanticAttributes.MAVEN_EXECUTION_LIFECYCLE_PHASE, mojoExecution.getLifecyclePhase()).startSpan();
        this.spanRegistry.putSpan(span, mojoExecution);
    }

    public void mojoSucceeded(ExecutionEvent executionEvent) {
        MojoExecution mojoExecution = executionEvent.getMojoExecution();
        logger.debug("OpenTelemetry: End succeeded mojo execution span: {}", (Object)mojoExecution);
        Span mojoExecutionSpan = this.spanRegistry.removeSpan(mojoExecution);
        mojoExecutionSpan.setStatus(StatusCode.OK);
        mojoExecutionSpan.end();
    }

    public void mojoFailed(ExecutionEvent executionEvent) {
        MojoExecution mojoExecution = executionEvent.getMojoExecution();
        logger.debug("OpenTelemetry: End failed mojo execution span: {}", (Object)mojoExecution);
        Span mojoExecutionSpan = this.spanRegistry.removeSpan(mojoExecution);
        mojoExecutionSpan.setStatus(StatusCode.ERROR, "Mojo Failed");
        mojoExecutionSpan.end();
    }

    public void sessionEnded(ExecutionEvent event) {
        logger.debug("OpenTelemetry: Maven session ended");
        this.spanRegistry.removeRootSpan().end();
    }

    protected String getPluginArtifactIdShortName(String pluginArtifactId) {
        if (pluginArtifactId.endsWith("-maven-plugin")) {
            return pluginArtifactId.substring(0, pluginArtifactId.length() - "-maven-plugin".length());
        }
        if (pluginArtifactId.startsWith("maven-") && pluginArtifactId.endsWith("-plugin")) {
            return pluginArtifactId.substring("maven-".length(), pluginArtifactId.length() - "-plugin".length());
        }
        return pluginArtifactId;
    }

    private static class ToUpperCaseTextMapGetter
    implements TextMapGetter<Map<String, String>> {
        private ToUpperCaseTextMapGetter() {
        }

        @Override
        public Iterable<String> keys(Map<String, String> environmentVariables) {
            return environmentVariables.keySet();
        }

        @Override
        public String get(Map<String, String> environmentVariables, String key) {
            return environmentVariables == null ? null : environmentVariables.get(key.toUpperCase(Locale.ROOT));
        }
    }
}

