/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.maven.StringUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class OtelUtils {
    OtelUtils() {
    }

    public static Map<String, String> getCommaSeparatedMap(String comaSeparatedKeyValuePairs) {
        if (StringUtils.isBlank(comaSeparatedKeyValuePairs)) {
            return Collections.emptyMap();
        }
        return OtelUtils.filterBlanksAndNulls(comaSeparatedKeyValuePairs.split(",")).stream().map(keyValuePair -> OtelUtils.filterBlanksAndNulls(keyValuePair.split("=", 2))).map(splitKeyValuePairs -> {
            if (splitKeyValuePairs.size() != 2) {
                throw new RuntimeException("Invalid key-value paire: " + comaSeparatedKeyValuePairs);
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>((String)splitKeyValuePairs.get(0), (String)splitKeyValuePairs.get(1));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, next) -> next, LinkedHashMap::new));
    }

    private static List<String> filterBlanksAndNulls(String[] values) {
        return Arrays.stream(values).map(String::trim).filter(s2 -> !s2.isEmpty()).collect(Collectors.toList());
    }
}

