/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BoundLongCounter;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.SdkDoubleCounter;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;

final class SdkLongCounter
extends AbstractInstrument
implements LongCounter {
    private final WriteableMetricStorage storage;

    private SdkLongCounter(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void add(long increment, Attributes attributes, Context context) {
        if (increment < 0L) {
            throw new IllegalArgumentException("Counters can only increase");
        }
        this.storage.recordLong(increment, attributes, context);
    }

    @Override
    public void add(long increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(long increment) {
        this.add(increment, Attributes.empty());
    }

    @Override
    public BoundLongCounter bind(Attributes attributes) {
        return new BoundInstrument(this.storage.bind(attributes), attributes);
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements LongCounterBuilder {
        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            this(meterProviderSharedState, meterSharedState, name, "", "1");
        }

        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, name, description, unit);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SdkLongCounter build() {
            return this.buildSynchronousInstrument(InstrumentType.COUNTER, InstrumentValueType.LONG, (x$0, x$1) -> new SdkLongCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public DoubleCounterBuilder ofDoubles() {
            return this.swapBuilder(SdkDoubleCounter.Builder::new);
        }

        @Override
        public void buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            this.registerLongAsynchronousInstrument(InstrumentType.OBSERVABLE_SUM, callback);
        }
    }

    static final class BoundInstrument
    implements BoundLongCounter {
        private final BoundStorageHandle handle;
        private final Attributes attributes;

        BoundInstrument(BoundStorageHandle handle, Attributes attributes) {
            this.handle = handle;
            this.attributes = attributes;
        }

        @Override
        public void add(long increment, Context context) {
            if (increment < 0L) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            this.handle.recordLong(increment, this.attributes, context);
        }

        @Override
        public void add(long increment) {
            this.add(increment, Context.current());
        }

        @Override
        public void unbind() {
            this.handle.release();
        }
    }
}

