/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.Response;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class AwsSdkHttpAttributesGetter
implements HttpClientAttributesGetter<Request<?>, Response<?>> {
    AwsSdkHttpAttributesGetter() {
    }

    public String url(Request<?> request) {
        return request.getEndpoint().toString();
    }

    @Nullable
    public String flavor(Request<?> request, @Nullable Response<?> response) {
        return "1.1";
    }

    public String method(Request<?> request) {
        return request.getHttpMethod().name();
    }

    public List<String> requestHeader(Request<?> request, String name) {
        String value = (String)request.getHeaders().get(name.equals("user-agent") ? "User-Agent" : name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    @Nullable
    public Long requestContentLength(Request<?> request, @Nullable Response<?> response) {
        return null;
    }

    @Nullable
    public Long requestContentLengthUncompressed(Request<?> request, @Nullable Response<?> response) {
        return null;
    }

    public Integer statusCode(Request<?> request, Response<?> response) {
        return response.getHttpResponse().getStatusCode();
    }

    @Nullable
    public Long responseContentLength(Request<?> request, Response<?> response) {
        return null;
    }

    @Nullable
    public Long responseContentLengthUncompressed(Request<?> request, Response<?> response) {
        return null;
    }

    public List<String> responseHeader(Request<?> request, Response<?> response, String name) {
        String value = (String)response.getHttpResponse().getHeaders().get(name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }
}

