/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcAttributesGetter;

enum AwsSdkRpcAttributesGetter implements RpcAttributesGetter<Request<?>>
{
    INSTANCE;

    private static final ClassValue<String> OPERATION_NAME;

    public String system(Request<?> request) {
        return "aws-api";
    }

    public String service(Request<?> request) {
        return request.getServiceName();
    }

    public String method(Request<?> request) {
        return OPERATION_NAME.get(request.getOriginalRequest().getClass());
    }

    static {
        OPERATION_NAME = new ClassValue<String>(){

            @Override
            protected String computeValue(Class<?> type) {
                String ret = type.getSimpleName();
                if (!ret.endsWith("Request")) {
                    ret = type.getSuperclass().getSimpleName();
                }
                if (ret.endsWith("Request")) {
                    ret = ret.substring(0, ret.length() - 7);
                }
                return ret;
            }
        };
    }
}

