/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;

class AwsSdkSpanKindExtractor
implements SpanKindExtractor<Request<?>> {
    AwsSdkSpanKindExtractor() {
    }

    public SpanKind extract(Request<?> request) {
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        return AwsSdkSpanKindExtractor.isSqsProducer(originalRequest) ? SpanKind.PRODUCER : SpanKind.CLIENT;
    }

    private static boolean isSqsProducer(AmazonWebServiceRequest request) {
        return request.getClass().getName().equals("com.amazonaws.services.sqs.model.SendMessageRequest");
    }
}

