/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.RequestHandler2;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkInstrumenterFactory;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkTelemetryBuilder;
import io.opentelemetry.instrumentation.awssdk.v1_11.TracingRequestHandler;

public class AwsSdkTelemetry {
    private final Instrumenter<Request<?>, Response<?>> requestInstrumenter;
    private final Instrumenter<Request<?>, Response<?>> consumerInstrumenter;

    public static Context getOpenTelemetryContext(Request<?> request) {
        return (Context)request.getHandlerContext(TracingRequestHandler.CONTEXT);
    }

    public static AwsSdkTelemetry create(OpenTelemetry openTelemetry) {
        return AwsSdkTelemetry.builder(openTelemetry).build();
    }

    public static AwsSdkTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new AwsSdkTelemetryBuilder(openTelemetry);
    }

    AwsSdkTelemetry(OpenTelemetry openTelemetry, boolean captureExperimentalSpanAttributes) {
        this.requestInstrumenter = AwsSdkInstrumenterFactory.requestInstrumenter(openTelemetry, captureExperimentalSpanAttributes);
        this.consumerInstrumenter = AwsSdkInstrumenterFactory.consumerInstrumenter(openTelemetry, captureExperimentalSpanAttributes);
    }

    public RequestHandler2 newRequestHandler() {
        return new TracingRequestHandler(this.requestInstrumenter, this.consumerInstrumenter);
    }
}

