/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class SqsReceiveMessageResultAccess {
    @Nullable
    private static final MethodHandle GET_MESSAGES;

    static List<?> getMessages(Object result) {
        if (GET_MESSAGES == null) {
            return Collections.emptyList();
        }
        try {
            return GET_MESSAGES.invoke(result);
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    private SqsReceiveMessageResultAccess() {
    }

    static {
        Class<?> receiveMessageResultClass = null;
        try {
            receiveMessageResultClass = Class.forName("com.amazonaws.services.sqs.model.ReceiveMessageResult");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (receiveMessageResultClass != null) {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodHandle getMessages = null;
            try {
                getMessages = lookup.findVirtual(receiveMessageResultClass, "getMessages", MethodType.methodType(List.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            GET_MESSAGES = getMessages;
        } else {
            GET_MESSAGES = null;
        }
    }
}

