/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.RequestAccess;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsAccess;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

enum SqsAttributesGetter implements MessagingAttributesGetter<Request<?>, Response<?>>
{
    INSTANCE;


    public String getSystem(Request<?> request) {
        return "AmazonSQS";
    }

    public String getDestination(Request<?> request) {
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        String queueUrl = RequestAccess.getQueueUrl(originalRequest);
        int i = queueUrl.lastIndexOf(47);
        return i > 0 ? queueUrl.substring(i + 1) : null;
    }

    public boolean isTemporaryDestination(Request<?> request) {
        return false;
    }

    @Nullable
    public String getConversationId(Request<?> request) {
        return null;
    }

    @Nullable
    public Long getMessagePayloadSize(Request<?> request) {
        return null;
    }

    @Nullable
    public Long getMessagePayloadCompressedSize(Request<?> request) {
        return null;
    }

    @Nullable
    public String getMessageId(Request<?> request, @Nullable Response<?> response) {
        return SqsAccess.getMessageId(response);
    }

    public List<String> getMessageHeader(Request<?> request, String name) {
        String value = SqsAccess.getMessageAttribute(request, name);
        return value != null ? Collections.singletonList(value) : Collections.emptyList();
    }
}

