/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.api.internal.Timer;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsMessageImpl;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsReceiveRequest;
import io.opentelemetry.instrumentation.awssdk.v1_11.TracingList;
import io.opentelemetry.instrumentation.awssdk.v1_11.TracingRequestHandler;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.Map;

final class SqsImpl {
    private static final Field messagesField;

    private SqsImpl() {
    }

    static boolean afterResponse(Request<?> request, Response<?> response, Timer timer, Context parentContext, TracingRequestHandler requestHandler) {
        if (response.getAwsResponse() instanceof ReceiveMessageResult) {
            SqsImpl.afterConsumerResponse(request, response, timer, parentContext, requestHandler);
            return true;
        }
        return false;
    }

    private static void afterConsumerResponse(Request<?> request, Response<?> response, Timer timer, Context parentContext, TracingRequestHandler requestHandler) {
        ReceiveMessageResult receiveMessageResult = (ReceiveMessageResult)response.getAwsResponse();
        if (receiveMessageResult.getMessages().isEmpty()) {
            return;
        }
        Instrumenter<SqsReceiveRequest, Response<?>> consumerReceiveInstrumenter = requestHandler.getConsumerReceiveInstrumenter();
        Instrumenter<SqsProcessRequest, Void> consumerProcessInstrumenter = requestHandler.getConsumerProcessInstrumenter();
        Context receiveContext = null;
        SqsReceiveRequest receiveRequest = SqsReceiveRequest.create(request, SqsMessageImpl.wrap(receiveMessageResult.getMessages()));
        if (timer != null && consumerReceiveInstrumenter.shouldStart(parentContext, (Object)receiveRequest)) {
            receiveContext = InstrumenterUtil.startAndEnd(consumerReceiveInstrumenter, (Context)parentContext, (Object)receiveRequest, response, null, (Instant)timer.startTime(), (Instant)timer.now());
        }
        SqsImpl.addTracing(receiveMessageResult, request, consumerProcessInstrumenter, receiveContext);
    }

    private static Field getMessagesField() {
        try {
            Field field = ReceiveMessageResult.class.getDeclaredField("messages");
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void addTracing(ReceiveMessageResult receiveMessageResult, Request<?> request, Instrumenter<SqsProcessRequest, Void> consumerProcessInstrumenter, Context receiveContext) {
        if (messagesField == null) {
            return;
        }
        try {
            messagesField.set(receiveMessageResult, TracingList.wrap(receiveMessageResult.getMessages(), consumerProcessInstrumenter, request, receiveContext));
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    static boolean beforeMarshalling(AmazonWebServiceRequest rawRequest) {
        if (rawRequest instanceof ReceiveMessageRequest) {
            ReceiveMessageRequest request = (ReceiveMessageRequest)rawRequest;
            if (!request.getAttributeNames().contains("AWSTraceHeader")) {
                request.withAttributeNames(new String[]{"AWSTraceHeader"});
            }
            return true;
        }
        return false;
    }

    static String getMessageAttribute(Request<?> request, String name) {
        Map map;
        MessageAttributeValue value;
        if (request.getOriginalRequest() instanceof SendMessageRequest && (value = (MessageAttributeValue)(map = ((SendMessageRequest)request.getOriginalRequest()).getMessageAttributes()).get(name)) != null) {
            return value.getStringValue();
        }
        return null;
    }

    static String getMessageId(Response<?> response) {
        if (response != null && response.getAwsResponse() instanceof SendMessageResult) {
            return ((SendMessageResult)response.getAwsResponse()).getMessageId();
        }
        return null;
    }

    static {
        String string = AmazonSQS.class.getName();
        messagesField = SqsImpl.getMessagesField();
    }
}

