/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.Message;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsMessageImpl;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsParentContext;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsProcessRequest;
import java.util.Iterator;
import javax.annotation.Nullable;

class TracingIterator
implements Iterator<Message> {
    private final Iterator<Message> delegateIterator;
    private final Instrumenter<SqsProcessRequest, Void> instrumenter;
    private final Request<?> request;
    private final Context receiveContext;
    @Nullable
    private SqsProcessRequest currentRequest;
    @Nullable
    private Context currentContext;
    @Nullable
    private Scope currentScope;

    private TracingIterator(Iterator<Message> delegateIterator, Instrumenter<SqsProcessRequest, Void> instrumenter, Request<?> request, Context receiveContext) {
        this.delegateIterator = delegateIterator;
        this.instrumenter = instrumenter;
        this.request = request;
        this.receiveContext = receiveContext;
    }

    public static Iterator<Message> wrap(Iterator<Message> delegateIterator, Instrumenter<SqsProcessRequest, Void> instrumenter, Request<?> request, Context receiveContext) {
        return new TracingIterator(delegateIterator, instrumenter, request, receiveContext);
    }

    @Override
    public boolean hasNext() {
        this.closeScopeAndEndSpan();
        return this.delegateIterator.hasNext();
    }

    @Override
    public Message next() {
        this.closeScopeAndEndSpan();
        Message next = this.delegateIterator.next();
        if (next != null) {
            Context parentContext = this.receiveContext;
            if (parentContext == null) {
                parentContext = SqsParentContext.ofSystemAttributes(next.getAttributes());
            }
            this.currentRequest = SqsProcessRequest.create(this.request, SqsMessageImpl.wrap(next));
            this.currentContext = this.instrumenter.start(parentContext, (Object)this.currentRequest);
            this.currentScope = this.currentContext.makeCurrent();
        }
        return next;
    }

    private void closeScopeAndEndSpan() {
        if (this.currentScope != null) {
            this.currentScope.close();
            this.instrumenter.end(this.currentContext, (Object)this.currentRequest, null, null);
            this.currentScope = null;
            this.currentRequest = null;
            this.currentContext = null;
        }
    }

    @Override
    public void remove() {
        this.delegateIterator.remove();
    }
}

