/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.Message;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v1_11.TracingIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

class TracingList
extends SdkInternalList<Message> {
    private static final long serialVersionUID = 1L;
    private final transient Instrumenter<SqsProcessRequest, Void> instrumenter;
    private final transient Request<?> request;
    private final transient Context receiveContext;
    private boolean firstIterator = true;

    private TracingList(List<Message> list, Instrumenter<SqsProcessRequest, Void> instrumenter, Request<?> request, Context receiveContext) {
        super(list);
        this.instrumenter = instrumenter;
        this.request = request;
        this.receiveContext = receiveContext;
    }

    public static SdkInternalList<Message> wrap(List<Message> list, Instrumenter<SqsProcessRequest, Void> instrumenter, Request<?> request, Context receiveContext) {
        return new TracingList(list, instrumenter, request, receiveContext);
    }

    public Iterator<Message> iterator() {
        Iterator<Message> it;
        if (this.firstIterator && !TracingList.inAwsClient()) {
            it = TracingIterator.wrap(super.iterator(), this.instrumenter, this.request, this.receiveContext);
            this.firstIterator = false;
        } else {
            it = super.iterator();
        }
        return it;
    }

    public void forEach(Consumer<? super Message> action) {
        Iterator<Message> iterator = this.iterator();
        while (iterator.hasNext()) {
            Message message = iterator.next();
            action.accept((Message)message);
        }
    }

    private static boolean inAwsClient() {
        for (Class<?> caller : CallerClass.INSTANCE.getClassContext()) {
            if (AmazonSQSClient.class != caller) continue;
            return true;
        }
        return false;
    }

    private Object writeReplace() {
        return new SdkInternalList((Collection)((Object)this));
    }

    private static class CallerClass
    extends SecurityManager {
        public static final CallerClass INSTANCE = new CallerClass();

        private CallerClass() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

