/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import java.util.logging.Level;
import java.util.logging.Logger;

final class PluginImplUtil {
    private static final Logger logger = Logger.getLogger(PluginImplUtil.class.getName());

    private PluginImplUtil() {
    }

    static boolean isImplPresent(String implSimpleClassName) {
        String implFullClassName = PluginImplUtil.class.getName().replace(".PluginImplUtil", "." + implSimpleClassName);
        try {
            Class.forName(implFullClassName);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            logger.log(Level.FINE, () -> "Failed to load " + implFullClassName + " (" + e.getClass().getName() + "). Most likely, corresponding SDK component is either not on classpath or incompatible.");
            return false;
        }
    }
}

