/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Response;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.RequestAccess;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsProcessRequest;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

enum SqsProcessRequestAttributesGetter implements MessagingAttributesGetter<SqsProcessRequest, Response<?>>
{
    INSTANCE;

    private static final String AWS_SQS = "aws_sqs";

    public String getSystem(SqsProcessRequest request) {
        return AWS_SQS;
    }

    public String getDestination(SqsProcessRequest request) {
        AmazonWebServiceRequest originalRequest = request.getRequest().getOriginalRequest();
        String queueUrl = RequestAccess.getQueueUrl(originalRequest);
        int i = queueUrl.lastIndexOf(47);
        return i > 0 ? queueUrl.substring(i + 1) : null;
    }

    @Nullable
    public String getDestinationTemplate(SqsProcessRequest request) {
        return null;
    }

    public boolean isTemporaryDestination(SqsProcessRequest request) {
        return false;
    }

    public boolean isAnonymousDestination(SqsProcessRequest request) {
        return false;
    }

    @Nullable
    public String getConversationId(SqsProcessRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageBodySize(SqsProcessRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageEnvelopeSize(SqsProcessRequest request) {
        return null;
    }

    @Nullable
    public String getMessageId(SqsProcessRequest request, @Nullable Response<?> response) {
        return request.getMessage().getMessageId();
    }

    @Nullable
    public String getClientId(SqsProcessRequest request) {
        return null;
    }

    @Nullable
    public Long getBatchMessageCount(SqsProcessRequest request, @Nullable Response<?> response) {
        return null;
    }

    public List<String> getMessageHeader(SqsProcessRequest request, String name) {
        String value = request.getMessage().getMessageAttribute(name);
        return value != null ? Collections.singletonList(value) : Collections.emptyList();
    }
}

