/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.instrumentation.awssdk.v2_2.SdkRequestDecorator;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;

final class DbRequestDecorator
implements SdkRequestDecorator {
    DbRequestDecorator() {
    }

    @Override
    public void decorate(Span span, SdkRequest sdkRequest, ExecutionAttributes attributes) {
        span.setAttribute(SemanticAttributes.DB_SYSTEM, (Object)"dynamodb");
        sdkRequest.getValueForField("TableName", String.class).ifPresent(val -> span.setAttribute(SemanticAttributes.DB_NAME, val));
        String operation = (String)attributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        if (operation != null) {
            span.setAttribute(SemanticAttributes.DB_OPERATION, (Object)operation);
        }
    }
}

