/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.awssdk.core.SdkRequest;

enum RequestType {
    S3("S3Request", "Bucket"),
    SQS("SqsRequest", "QueueUrl", "QueueName"),
    Kinesis("KinesisRequest", "StreamName"),
    DynamoDB("DynamoDbRequest", "TableName");

    private final String requestClass;
    private final String[] fields;

    private RequestType(String requestClass, String ... fields) {
        this.requestClass = requestClass;
        this.fields = fields;
    }

    String[] getFields() {
        return this.fields;
    }

    static @Nullable RequestType ofSdkRequest(SdkRequest request) {
        String typeName = (request.getClass().getSuperclass() == null ? request.getClass() : request.getClass().getSuperclass()).getSimpleName();
        for (RequestType type : RequestType.values()) {
            if (!type.requestClass.equals(typeName)) continue;
            return type;
        }
        return null;
    }
}

