/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdk;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkHttpClientTracer;
import io.opentelemetry.instrumentation.awssdk.v2_2.DbRequestDecorator;
import io.opentelemetry.instrumentation.awssdk.v2_2.RequestType;
import io.opentelemetry.instrumentation.awssdk.v2_2.SdkRequestDecorator;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;

final class TracingExecutionInterceptor
implements ExecutionInterceptor {
    static final ExecutionAttribute<Context> CONTEXT_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".Context");
    static final ExecutionAttribute<Scope> SCOPE_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".Scope");
    static final ExecutionAttribute<RequestType> REQUEST_TYPE_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".RequestType");
    static final String COMPONENT_NAME = "java-aws-sdk";
    private static final Map<RequestType, SdkRequestDecorator> TYPE_TO_DECORATOR = TracingExecutionInterceptor.mapDecorators();
    private static final Map<String, String> FIELD_TO_ATTRIBUTE = TracingExecutionInterceptor.mapFieldToAttribute();

    TracingExecutionInterceptor() {
    }

    private static Map<RequestType, SdkRequestDecorator> mapDecorators() {
        EnumMap<RequestType, SdkRequestDecorator> result = new EnumMap<RequestType, SdkRequestDecorator>(RequestType.class);
        result.put(RequestType.DynamoDB, new DbRequestDecorator());
        return result;
    }

    private static Map<String, String> mapFieldToAttribute() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("QueueUrl", "aws.queue.url");
        result.put("Bucket", "aws.bucket.name");
        result.put("QueueName", "aws.queue.name");
        result.put("StreamName", "aws.stream.name");
        result.put("TableName", "aws.table.name");
        return result;
    }

    private @Nullable SdkRequestDecorator decorator(ExecutionAttributes executionAttributes) {
        RequestType type = this.getTypeFromAttributes(executionAttributes);
        return TYPE_TO_DECORATOR.get((Object)type);
    }

    private RequestType getTypeFromAttributes(ExecutionAttributes executionAttributes) {
        return (RequestType)((Object)executionAttributes.getAttribute(REQUEST_TYPE_ATTRIBUTE));
    }

    public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        Context parentOtelContext = Context.current();
        if (!AwsSdkHttpClientTracer.tracer().shouldStartSpan(parentOtelContext)) {
            return;
        }
        Context otelContext = AwsSdkHttpClientTracer.tracer().startSpan(parentOtelContext, executionAttributes);
        executionAttributes.putAttribute(CONTEXT_ATTRIBUTE, (Object)otelContext);
        RequestType type = RequestType.ofSdkRequest(context.request());
        if (type != null) {
            executionAttributes.putAttribute(REQUEST_TYPE_ATTRIBUTE, (Object)type);
        }
        if (((ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE)).equals((Object)ClientType.SYNC)) {
            executionAttributes.putAttribute(SCOPE_ATTRIBUTE, (Object)otelContext.makeCurrent());
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Context otelContext = AwsSdk.getContext(executionAttributes);
        if (otelContext == null) {
            return context.httpRequest();
        }
        SdkHttpRequest.Builder builder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
        AwsSdkHttpClientTracer.tracer().inject(otelContext, builder);
        return (SdkHttpRequest)builder.build();
    }

    public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
        Context otelContext = AwsSdk.getContext(executionAttributes);
        if (otelContext == null) {
            return;
        }
        Span span = Span.fromContext((Context)otelContext);
        AwsSdkHttpClientTracer.tracer().onRequest(span, context.httpRequest());
        SdkRequestDecorator decorator = this.decorator(executionAttributes);
        if (decorator != null) {
            decorator.decorate(span, context.request(), executionAttributes);
        }
        this.decorateWithGenericRequestData(span, context.request());
        this.decorateWithExAttributesData(span, executionAttributes);
    }

    private void decorateWithGenericRequestData(Span span, SdkRequest request) {
        RequestType type = RequestType.ofSdkRequest(request);
        if (type != null) {
            for (String field : type.getFields()) {
                request.getValueForField(field, String.class).ifPresent(val -> span.setAttribute(FIELD_TO_ATTRIBUTE.get(field), val));
            }
        }
    }

    private void decorateWithExAttributesData(Span span, ExecutionAttributes attributes) {
        String awsServiceName = (String)attributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String awsOperation = (String)attributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        span.setAttribute("aws.agent", COMPONENT_NAME);
        span.setAttribute("aws.service", awsServiceName);
        span.setAttribute("aws.operation", awsOperation);
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        Scope scope = (Scope)executionAttributes.getAttribute(SCOPE_ATTRIBUTE);
        if (scope != null) {
            scope.close();
        }
        Context otelContext = AwsSdk.getContext(executionAttributes);
        this.clearAttributes(executionAttributes);
        Span span = Span.fromContext((Context)otelContext);
        this.onUserAgentHeaderAvailable(span, context.httpRequest());
        this.onSdkResponse(span, context.response());
        AwsSdkHttpClientTracer.tracer().end(otelContext, context.httpResponse());
    }

    private void onUserAgentHeaderAvailable(Span span, SdkHttpRequest request) {
        span.setAttribute(SemanticAttributes.HTTP_USER_AGENT, (Object)AwsSdkHttpClientTracer.tracer().requestHeader(request, "User-Agent"));
    }

    private void onSdkResponse(Span span, SdkResponse response) {
        if (response instanceof AwsResponse) {
            span.setAttribute("aws.requestId", ((AwsResponse)response).responseMetadata().requestId());
        }
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        Context otelContext = AwsSdk.getContext(executionAttributes);
        this.clearAttributes(executionAttributes);
        AwsSdkHttpClientTracer.tracer().endExceptionally(otelContext, context.exception());
    }

    private void clearAttributes(ExecutionAttributes executionAttributes) {
        executionAttributes.putAttribute(CONTEXT_ATTRIBUTE, null);
        executionAttributes.putAttribute(REQUEST_TYPE_ATTRIBUTE, null);
    }
}

