/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.hikaricp.v3_0;

import com.zaxxer.hikari.metrics.IMetricsTracker;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.metrics.PoolStats;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbConnectionPoolMetrics;
import io.opentelemetry.instrumentation.hikaricp.v3_0.OpenTelemetryMetricsTracker;
import javax.annotation.Nullable;

final class OpenTelemetryMetricsTrackerFactory
implements MetricsTrackerFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.hikaricp-3.0";
    private final OpenTelemetry openTelemetry;
    @Nullable
    private final MetricsTrackerFactory userMetricsFactory;

    OpenTelemetryMetricsTrackerFactory(OpenTelemetry openTelemetry, @Nullable MetricsTrackerFactory userMetricsFactory) {
        this.openTelemetry = openTelemetry;
        this.userMetricsFactory = userMetricsFactory;
    }

    public IMetricsTracker create(String poolName, PoolStats poolStats) {
        NoopMetricsTracker userMetricsTracker = this.userMetricsFactory == null ? NoopMetricsTracker.INSTANCE : this.userMetricsFactory.create(poolName, poolStats);
        DbConnectionPoolMetrics metrics = DbConnectionPoolMetrics.create((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (String)poolName);
        ObservableLongMeasurement connections = metrics.connections();
        ObservableLongMeasurement minIdleConnections = metrics.minIdleConnections();
        ObservableLongMeasurement maxConnections = metrics.maxConnections();
        ObservableLongMeasurement pendingRequestsForConnection = metrics.pendingRequestsForConnection();
        Attributes attributes = metrics.getAttributes();
        Attributes usedConnectionsAttributes = metrics.getUsedConnectionsAttributes();
        Attributes idleConnectionsAttributes = metrics.getIdleConnectionsAttributes();
        BatchCallback callback = metrics.batchCallback(() -> {
            connections.record((long)poolStats.getActiveConnections(), usedConnectionsAttributes);
            connections.record((long)poolStats.getIdleConnections(), idleConnectionsAttributes);
            minIdleConnections.record((long)poolStats.getMinConnections(), attributes);
            maxConnections.record((long)poolStats.getMaxConnections(), attributes);
            pendingRequestsForConnection.record((long)poolStats.getPendingThreads(), attributes);
        }, (ObservableMeasurement)connections, new ObservableMeasurement[]{minIdleConnections, maxConnections, pendingRequestsForConnection});
        return new OpenTelemetryMetricsTracker(userMetricsTracker, callback, metrics.connectionTimeouts(), metrics.connectionCreateTime(), metrics.connectionWaitTime(), metrics.connectionUseTime(), metrics.getAttributes());
    }

    static enum NoopMetricsTracker implements IMetricsTracker
    {
        INSTANCE;

    }
}

