/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CollectionParsers {
    private static final Logger log = LoggerFactory.getLogger(CollectionParsers.class);

    static List<String> parseList(String value) {
        String[] tokens = value.split(",", -1);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    static Map<String, String> parseMap(String value) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String token : value.split(",", -1)) {
            String[] parts = (token = token.trim()).split("=", -1);
            if (parts.length != 2) {
                log.warn("Invalid map config part, should be formatted key1=value1,key2=value2: {}", (Object)value);
                return Collections.emptyMap();
            }
            result.put(parts[0], parts[1]);
        }
        return Collections.unmodifiableMap(result);
    }

    private CollectionParsers() {
    }
}

