/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.InstrumentationVersion;
import io.opentelemetry.instrumentation.api.context.ContextPropagationDebug;
import io.opentelemetry.instrumentation.api.tracer.HttpServerTracer;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTracer {
    private static final Logger log = LoggerFactory.getLogger(HttpServerTracer.class);
    private static final boolean FAIL_ON_CONTEXT_LEAK = Boolean.getBoolean("otel.internal.failOnContextLeak");
    public static final ContextKey<Span> CONTEXT_SERVER_SPAN_KEY = ContextKey.named((String)"opentelemetry-trace-server-span-key");
    public static final ContextKey<Span> CONTEXT_CLIENT_SPAN_KEY = ContextKey.named((String)"opentelemetry-trace-auto-client-span-key");
    protected final Tracer tracer;

    public BaseTracer() {
        this.tracer = OpenTelemetry.getGlobalTracer((String)this.getInstrumentationName(), (String)this.getVersion());
    }

    public BaseTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public Span startSpan(Class<?> clazz) {
        String spanName = this.spanNameForClass(clazz);
        return this.startSpan(spanName, Span.Kind.INTERNAL);
    }

    public Span startSpan(Method method) {
        String spanName = this.spanNameForMethod(method);
        return this.startSpan(spanName, Span.Kind.INTERNAL);
    }

    public Span startSpan(String spanName, Span.Kind kind) {
        return this.tracer.spanBuilder(spanName).setSpanKind(kind).startSpan();
    }

    public Scope startScope(Span span) {
        return Context.current().with((ImplicitContextKeyed)span).makeCurrent();
    }

    public Span getCurrentSpan() {
        return Span.current();
    }

    protected abstract String getInstrumentationName();

    protected String getVersion() {
        return InstrumentationVersion.VERSION;
    }

    public String spanNameForMethod(Method method) {
        return this.spanNameForClass(method.getDeclaringClass()) + "." + method.getName();
    }

    protected String spanNameForMethod(Class<?> clazz, Method method) {
        return this.spanNameForMethod(clazz, null == method ? null : method.getName());
    }

    protected String spanNameForMethod(Class<?> cl, String methodName) {
        return this.spanNameForClass(cl) + "." + methodName;
    }

    public String spanNameForClass(Class<?> clazz) {
        String pkgName;
        if (!clazz.isAnonymousClass()) {
            return clazz.getSimpleName();
        }
        String className = clazz.getName();
        if (clazz.getPackage() != null && !(pkgName = clazz.getPackage().getName()).isEmpty()) {
            className = clazz.getName().replace(pkgName, "").substring(1);
        }
        return className;
    }

    public void end(Span span) {
        this.end(span, -1L);
    }

    public void end(Span span, long endTimeNanos) {
        if (endTimeNanos > 0L) {
            span.end(endTimeNanos, TimeUnit.NANOSECONDS);
        } else {
            span.end();
        }
    }

    public void endExceptionally(Span span, Throwable throwable) {
        this.endExceptionally(span, throwable, -1L);
    }

    public void endExceptionally(Span span, Throwable throwable, long endTimeNanos) {
        span.setStatus(StatusCode.ERROR);
        this.onError(span, this.unwrapThrowable(throwable));
        this.end(span, endTimeNanos);
    }

    protected void onError(Span span, Throwable throwable) {
        this.addThrowable(span, throwable);
    }

    protected Throwable unwrapThrowable(Throwable throwable) {
        return throwable instanceof ExecutionException ? throwable.getCause() : throwable;
    }

    public void addThrowable(Span span, Throwable throwable) {
        span.recordException(throwable);
    }

    public static <C> Context extract(C carrier, TextMapPropagator.Getter<C> getter) {
        if (ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            BaseTracer.debugContextLeak();
        }
        return OpenTelemetry.getGlobalPropagators().getTextMapPropagator().extract(Context.root(), carrier, getter);
    }

    private static void debugContextLeak() {
        Context current = Context.current();
        if (current != Context.root()) {
            List<StackTraceElement[]> locations;
            log.error("Unexpected non-root current context found when extracting remote context!");
            Span currentSpan = Span.fromContextOrNull((Context)current);
            if (currentSpan != null) {
                log.error("It contains this span: {}", (Object)currentSpan);
            }
            if ((locations = ContextPropagationDebug.getLocations(current)) != null) {
                StringBuilder sb = new StringBuilder();
                Iterator<StackTraceElement[]> i = locations.iterator();
                while (i.hasNext()) {
                    for (StackTraceElement ste : i.next()) {
                        sb.append("\n");
                        sb.append(ste);
                    }
                    if (!i.hasNext()) continue;
                    sb.append("\nwhich was propagated from:");
                }
                log.error("a context leak was detected. it was propagated from:{}", (Object)sb);
            }
            if (FAIL_ON_CONTEXT_LEAK) {
                throw new IllegalStateException("Context leak detected");
            }
        }
    }

    public static Span getCurrentServerSpan() {
        return BaseTracer.getCurrentServerSpan(Context.current());
    }

    public static Span getCurrentServerSpan(Context context) {
        return (Span)context.get(CONTEXT_SERVER_SPAN_KEY);
    }
}

