/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.engine;

import io.opentelemetry.instrumentation.jmx.engine.AttributeInfo;
import io.opentelemetry.instrumentation.jmx.engine.MetricAttributeExtractor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class BeanAttributeExtractor
implements MetricAttributeExtractor {
    private static final Logger logger = Logger.getLogger(BeanAttributeExtractor.class.getName());
    private final String baseName;
    private final String[] nameChain;

    public static BeanAttributeExtractor fromName(String rawName) {
        if (rawName.isEmpty()) {
            throw new IllegalArgumentException("Empty attribute name");
        }
        int k = rawName.indexOf(46);
        if (k < 0) {
            return new BeanAttributeExtractor(rawName, new String[0]);
        }
        String baseName = rawName.substring(0, k).trim();
        String[] components = rawName.substring(k + 1).split("\\.");
        if (baseName.isEmpty()) {
            throw new IllegalArgumentException("Invalid attribute name '" + rawName + "'");
        }
        for (int j = 0; j < components.length; ++j) {
            components[j] = components[j].trim();
            if (!components[j].isEmpty()) continue;
            throw new IllegalArgumentException("Invalid attribute name '" + rawName + "'");
        }
        return new BeanAttributeExtractor(baseName, components);
    }

    public BeanAttributeExtractor(String baseName, String ... nameChain) {
        if (baseName == null || nameChain == null) {
            throw new IllegalArgumentException("null argument for BeanAttributeExtractor");
        }
        this.baseName = baseName;
        this.nameChain = nameChain;
    }

    String getAttributeName() {
        if (this.nameChain.length > 0) {
            StringBuilder builder = new StringBuilder(this.baseName);
            for (String component : this.nameChain) {
                builder.append(".").append(component);
            }
            return builder.toString();
        }
        return this.baseName;
    }

    @Nullable
    AttributeInfo getAttributeInfo(MBeanServer server, ObjectName objectName) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Resolving {0} for {1}", new Object[]{this.getAttributeName(), objectName});
        }
        try {
            MBeanAttributeInfo[] allAttributes;
            MBeanInfo info = server.getMBeanInfo(objectName);
            for (MBeanAttributeInfo attr : allAttributes = info.getAttributes()) {
                Level logLevel;
                if (!this.baseName.equals(attr.getName())) continue;
                String description = attr.getDescription();
                Object sampleValue = this.extractAttributeValue(server, objectName, logger);
                if (sampleValue instanceof Number) {
                    return new AttributeInfo((Number)sampleValue, description);
                }
                Level level = logLevel = sampleValue == null ? Level.FINE : Level.INFO;
                if (logger.isLoggable(logLevel)) {
                    logger.log(logLevel, "Unusable value {0} for attribute {1} and ObjectName {2}", new Object[]{sampleValue == null ? "NULL" : sampleValue.getClass().getName(), this.getAttributeName(), objectName});
                }
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Cannot find attribute {0} for ObjectName {1}", new Object[]{this.baseName, objectName});
            }
        }
        catch (InstanceNotFoundException e) {
            logger.log(Level.INFO, "The MBeanServer does not find {0}", objectName);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception {0} while inspecting attributes for ObjectName {1}", new Object[]{e, objectName});
        }
        return null;
    }

    @Nullable
    private Object extractAttributeValue(MBeanServer server, ObjectName objectName, Logger logger) {
        try {
            Object value = server.getAttribute(objectName, this.baseName);
            for (int k = 0; k < this.nameChain.length; ++k) {
                if (value instanceof CompositeData) {
                    value = ((CompositeData)value).get(this.nameChain[k]);
                    continue;
                }
                if (value instanceof TabularData) {
                    value = ((TabularData)value).get(new String[]{this.nameChain[k]});
                    continue;
                }
                if (logger == null) break;
                logger.log(Level.FINE, "Encountered a value of {0} while extracting attribute {1} for ObjectName {2}; unable to extract metric value", new Object[]{value == null ? "NULL" : value.getClass().getName(), this.getAttributeName(), objectName});
                break;
            }
            return value;
        }
        catch (Exception e) {
            if (logger != null) {
                logger.log(Level.FINE, "Encountered {0} while extracting attribute {1} for ObjectName {2}; unable to extract metric value", new Object[]{e, this.getAttributeName(), objectName});
            }
            return null;
        }
    }

    @Nullable
    private Object extractAttributeValue(MBeanServer server, ObjectName objectName) {
        return this.extractAttributeValue(server, objectName, null);
    }

    @Nullable
    Number extractNumericalAttribute(MBeanServer server, ObjectName objectName) {
        Object value = this.extractAttributeValue(server, objectName);
        if (value instanceof Number) {
            return (Number)value;
        }
        return null;
    }

    @Override
    @Nullable
    public String extractValue(MBeanServer server, ObjectName objectName) {
        return this.extractStringAttribute(server, objectName);
    }

    @Nullable
    private String extractStringAttribute(MBeanServer server, ObjectName objectName) {
        Object value = this.extractAttributeValue(server, objectName);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }
}

