/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.yaml;

import io.opentelemetry.instrumentation.jmx.engine.MetricInfo;
import io.opentelemetry.instrumentation.jmx.yaml.MetricStructure;

public class Metric
extends MetricStructure {
    private String metric;
    private String desc;

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = this.validateMetricName(metric.trim());
    }

    private String validateMetricName(String name) {
        this.requireNonEmpty(name, "The metric name is empty");
        return name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc.trim();
    }

    MetricInfo buildMetricInfo(String prefix, String attributeName, String defaultUnit, MetricInfo.Type defaultType) {
        String unit;
        String metricName = this.metric == null ? (prefix == null ? attributeName : prefix + attributeName) : (prefix == null ? this.metric : prefix + this.metric);
        MetricInfo.Type metricType = this.getMetricType();
        if (metricType == null) {
            metricType = defaultType;
        }
        if ((unit = this.getUnit()) == null) {
            unit = defaultUnit;
        }
        return new MetricInfo(metricName, this.desc, unit, metricType);
    }
}

