/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.yaml;

import io.opentelemetry.instrumentation.jmx.engine.MetricAttribute;
import io.opentelemetry.instrumentation.jmx.engine.MetricAttributeExtractor;
import io.opentelemetry.instrumentation.jmx.engine.MetricInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class MetricStructure {
    private String type;
    private Map<String, String> metricAttribute;
    private String unit;
    private MetricInfo.Type metricType;
    private List<MetricAttribute> metricAttributes;

    MetricStructure() {
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        t = t.trim().toUpperCase();
        this.metricType = MetricInfo.Type.valueOf(t);
        this.type = t;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = this.validateUnit(unit.trim());
    }

    private String validateUnit(String unit) {
        this.requireNonEmpty(unit, "Metric unit is empty");
        return unit;
    }

    public void setMetricAttribute(Map<String, String> map) {
        this.metricAttribute = map;
        ArrayList<MetricAttribute> attrList = new ArrayList<MetricAttribute>();
        MetricStructure.addMetricAttributes(attrList, map);
        this.metricAttributes = attrList;
    }

    public Map<String, String> getMetricAttribute() {
        return this.metricAttribute;
    }

    public MetricInfo.Type getMetricType() {
        return this.metricType;
    }

    protected List<MetricAttribute> getAttributeList() {
        return this.metricAttributes;
    }

    protected void requireNonEmpty(String s, String msg) {
        if (s.isEmpty()) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void addMetricAttributes(List<MetricAttribute> list, Map<String, String> metricAttributeMap) {
        if (metricAttributeMap != null) {
            for (String key : metricAttributeMap.keySet()) {
                String target = metricAttributeMap.get(key);
                if (target == null) {
                    throw new IllegalStateException("nothing specified for metric attribute key '" + key + "'");
                }
                list.add(MetricStructure.buildMetricAttribute(key, target.trim()));
            }
        }
    }

    private static MetricAttribute buildMetricAttribute(String key, String target) {
        int k = target.indexOf(41);
        if (target.startsWith("param(")) {
            if (k > 0) {
                return new MetricAttribute(key, MetricAttributeExtractor.fromObjectNameParameter(target.substring(6, k).trim()));
            }
        } else if (target.startsWith("beanattr(")) {
            if (k > 0) {
                return new MetricAttribute(key, MetricAttributeExtractor.fromBeanAttribute(target.substring(9, k).trim()));
            }
        } else if (target.startsWith("const(") && k > 0) {
            return new MetricAttribute(key, MetricAttributeExtractor.fromConstant(target.substring(6, k).trim()));
        }
        throw new IllegalArgumentException("Invalid metric attribute specification for '" + key + "'");
    }
}

