/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.yaml;

import io.opentelemetry.instrumentation.jmx.engine.MetricConfiguration;
import io.opentelemetry.instrumentation.jmx.yaml.JmxConfig;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class RuleParser {
    private static final Logger logger = Logger.getLogger(RuleParser.class.getName());
    private static final RuleParser theParser = new RuleParser();

    public static RuleParser get() {
        return theParser;
    }

    private RuleParser() {
    }

    public JmxConfig loadConfig(InputStream is) throws Exception {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(JmxConfig.class));
        return (JmxConfig)yaml.load(is);
    }

    public void addMetricDefsTo(MetricConfiguration conf, InputStream is) {
        try {
            JmxConfig config = this.loadConfig(is);
            if (config != null) {
                logger.log(Level.INFO, "Found {0} metric rules", config.getRules().size());
                config.addMetricDefsTo(conf);
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to parse YAML rules: " + RuleParser.rootCause(exception));
            logger.log(Level.WARNING, exception.toString());
        }
    }

    private static String rootCause(Throwable exception) {
        String rootClass = "";
        String message = null;
        while (exception != null) {
            rootClass = exception.getClass().getSimpleName();
            message = exception.getMessage();
            exception = exception.getCause();
        }
        return message == null ? rootClass : message;
    }
}

