/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.engine;

import io.opentelemetry.instrumentation.jmx.engine.AttributeInfo;
import io.opentelemetry.instrumentation.jmx.engine.BeanGroup;
import io.opentelemetry.instrumentation.jmx.engine.MetricConfiguration;
import io.opentelemetry.instrumentation.jmx.engine.MetricDef;
import io.opentelemetry.instrumentation.jmx.engine.MetricExtractor;
import io.opentelemetry.instrumentation.jmx.engine.MetricRegistrar;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class BeanFinder {
    private static final Logger logger = Logger.getLogger(BeanFinder.class.getName());
    private final MetricRegistrar registrar;
    private MetricConfiguration conf;
    private final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread result = new Thread(runnable, "jmx_bean_finder");
        result.setDaemon(true);
        return result;
    });
    private final long discoveryDelay;
    private final long maxDelay;
    private long delay = 1000L;

    BeanFinder(MetricRegistrar registrar, long discoveryDelay) {
        this.registrar = registrar;
        this.discoveryDelay = Math.max(1000L, discoveryDelay);
        this.maxDelay = Math.max(60000L, discoveryDelay);
    }

    void discoverBeans(MetricConfiguration conf, final Supplier<List<? extends MBeanServerConnection>> connections) {
        this.conf = conf;
        this.exec.schedule(() -> ManagementFactory.getPlatformMBeanServer(), this.discoveryDelay, TimeUnit.MILLISECONDS);
        this.exec.schedule(new Runnable(){

            @Override
            public void run() {
                BeanFinder.this.refreshState(connections);
                BeanFinder.this.delay = Math.min(BeanFinder.this.delay + BeanFinder.this.discoveryDelay, BeanFinder.this.maxDelay);
                BeanFinder.this.exec.schedule(this, BeanFinder.this.delay, TimeUnit.MILLISECONDS);
            }
        }, this.delay, TimeUnit.MILLISECONDS);
    }

    private void refreshState(Supplier<List<? extends MBeanServerConnection>> connections) {
        List<? extends MBeanServerConnection> servers = connections.get();
        for (MetricDef metricDef : this.conf.getMetricDefs()) {
            this.resolveBeans(metricDef, servers);
        }
    }

    private void resolveBeans(MetricDef metricDef, List<? extends MBeanServerConnection> connections) {
        BeanGroup beans = metricDef.getBeanGroup();
        for (MBeanServerConnection mBeanServerConnection : connections) {
            HashSet<ObjectName> allObjectNames = new HashSet<ObjectName>();
            for (ObjectName pattern : beans.getNamePatterns()) {
                try {
                    allObjectNames.addAll(mBeanServerConnection.queryNames(pattern, beans.getQueryExp()));
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "IO error while resolving mbean", e);
                }
            }
            if (allObjectNames.isEmpty()) continue;
            this.resolveAttributes(allObjectNames, mBeanServerConnection, metricDef);
            break;
        }
    }

    private void resolveAttributes(Set<ObjectName> objectNames, MBeanServerConnection connection, MetricDef metricDef) {
        for (MetricExtractor extractor : metricDef.getMetricExtractors()) {
            ArrayList<ObjectName> validObjectNames = new ArrayList<ObjectName>();
            AttributeInfo attributeInfo = null;
            for (ObjectName objectName : objectNames) {
                AttributeInfo attr = extractor.getMetricValueExtractor().getAttributeInfo(connection, objectName);
                if (attr == null) continue;
                if (attributeInfo == null) {
                    attributeInfo = attr;
                } else {
                    attributeInfo.updateFrom(attr);
                }
                validObjectNames.add(objectName);
            }
            if (validObjectNames.isEmpty()) continue;
            this.registrar.enrollExtractor(connection, validObjectNames, extractor, attributeInfo);
        }
    }
}

