/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyClientInstrumenterFactory;
import io.opentelemetry.instrumentation.netty.v4_1.NettyClientTelemetry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class NettyClientTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private List<String> capturedRequestHeaders = Collections.emptyList();
    private List<String> capturedResponseHeaders = Collections.emptyList();
    private final List<AttributesExtractor<HttpRequestAndChannel, HttpResponse>> additionalAttributesExtractors = new ArrayList<AttributesExtractor<HttpRequestAndChannel, HttpResponse>>();

    NettyClientTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public NettyClientTelemetryBuilder setCapturedRequestHeaders(List<String> capturedRequestHeaders) {
        this.capturedRequestHeaders = capturedRequestHeaders;
        return this;
    }

    @CanIgnoreReturnValue
    public NettyClientTelemetryBuilder setCapturedResponseHeaders(List<String> capturedResponseHeaders) {
        this.capturedResponseHeaders = capturedResponseHeaders;
        return this;
    }

    @CanIgnoreReturnValue
    public NettyClientTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpRequestAndChannel, HttpResponse> attributesExtractor) {
        this.additionalAttributesExtractors.add(attributesExtractor);
        return this;
    }

    public NettyClientTelemetry build() {
        return new NettyClientTelemetry((Instrumenter<HttpRequestAndChannel, HttpResponse>)new NettyClientInstrumenterFactory(this.openTelemetry, "io.opentelemetry.netty-4.1", false, false, Collections.emptyMap()).createHttpInstrumenter(this.capturedRequestHeaders, this.capturedResponseHeaders, this.additionalAttributesExtractors));
    }
}

