/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1.internal.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4_1.internal.AttributeKeys;

public class HttpClientRequestTracingHandler
extends ChannelOutboundHandlerAdapter {
    public static final AttributeKey<HttpRequestAndChannel> HTTP_REQUEST = AttributeKey.valueOf(HttpClientRequestTracingHandler.class, (String)"http-client-request");
    private final Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter;

    public HttpClientRequestTracingHandler(Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise prm) {
        HttpRequestAndChannel request;
        if (!(msg instanceof HttpRequest)) {
            ctx.write(msg, prm);
            return;
        }
        Context parentContext = (Context)ctx.channel().attr(AttributeKeys.WRITE_CONTEXT).getAndSet(null);
        if (parentContext == null) {
            parentContext = Context.current();
        }
        if (!this.instrumenter.shouldStart(parentContext, (Object)(request = HttpRequestAndChannel.create((HttpRequest)((HttpRequest)msg), (Channel)ctx.channel()))) || HttpClientRequestTracingHandler.isAwsRequest(request)) {
            ctx.write(msg, prm);
            return;
        }
        Attribute parentContextAttr = ctx.channel().attr(AttributeKeys.CLIENT_PARENT_CONTEXT);
        Attribute contextAttr = ctx.channel().attr(AttributeKeys.CLIENT_CONTEXT);
        Attribute requestAttr = ctx.channel().attr(HTTP_REQUEST);
        Context context = this.instrumenter.start(parentContext, (Object)request);
        parentContextAttr.set((Object)parentContext);
        contextAttr.set((Object)context);
        requestAttr.set((Object)request);
        try (Scope ignored = context.makeCurrent();){
            ctx.write(msg, prm);
        }
        catch (Throwable throwable) {
            this.instrumenter.end((Context)contextAttr.getAndSet(null), (Object)((HttpRequestAndChannel)requestAttr.getAndSet(null)), null, throwable);
            parentContextAttr.set(null);
            throw throwable;
        }
    }

    private static boolean isAwsRequest(HttpRequestAndChannel request) {
        return request.request().headers().contains("amz-sdk-invocation-id");
    }
}

