/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1.internal.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4_1.internal.AttributeKeys;
import io.opentelemetry.instrumentation.netty.v4_1.internal.client.HttpClientRequestTracingHandler;

public class HttpClientResponseTracingHandler
extends ChannelInboundHandlerAdapter {
    private static final AttributeKey<HttpResponse> HTTP_RESPONSE = AttributeKey.valueOf(HttpClientResponseTracingHandler.class, (String)"http-client-response");
    private final Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter;

    public HttpClientResponseTracingHandler(Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Attribute contextAttr = ctx.channel().attr(AttributeKeys.CLIENT_CONTEXT);
        Context context = (Context)contextAttr.get();
        if (context == null) {
            ctx.fireChannelRead(msg);
            return;
        }
        Attribute parentContextAttr = ctx.channel().attr(AttributeKeys.CLIENT_PARENT_CONTEXT);
        Attribute requestAttr = ctx.channel().attr(HttpClientRequestTracingHandler.HTTP_REQUEST);
        Context parentContext = (Context)parentContextAttr.get();
        HttpRequestAndChannel request = (HttpRequestAndChannel)requestAttr.get();
        if (msg instanceof FullHttpResponse) {
            parentContextAttr.set(null);
            contextAttr.set(null);
            requestAttr.set(null);
        } else if (msg instanceof HttpResponse) {
            ctx.channel().attr(HTTP_RESPONSE).set((Object)((HttpResponse)msg));
        } else if (msg instanceof LastHttpContent) {
            parentContextAttr.set(null);
            contextAttr.set(null);
            requestAttr.set(null);
        }
        if (parentContext != null) {
            try (Scope ignored = parentContext.makeCurrent();){
                ctx.fireChannelRead(msg);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
        if (msg instanceof FullHttpResponse) {
            this.instrumenter.end(context, (Object)request, (Object)((HttpResponse)msg), null);
        } else if (msg instanceof LastHttpContent) {
            this.instrumenter.end(context, (Object)request, (Object)((HttpResponse)ctx.channel().attr(HTTP_RESPONSE).getAndSet(null)), null);
        }
    }
}

