/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1.internal.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4_1.internal.AttributeKeys;

public class HttpServerRequestTracingHandler
extends ChannelInboundHandlerAdapter {
    static final AttributeKey<HttpRequestAndChannel> HTTP_REQUEST = AttributeKey.valueOf(HttpServerRequestTracingHandler.class, (String)"http-server-request");
    private final Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter;

    public HttpServerRequestTracingHandler(Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        HttpRequestAndChannel request;
        Channel channel = ctx.channel();
        Attribute contextAttr = channel.attr(AttributeKeys.SERVER_CONTEXT);
        Attribute requestAttr = channel.attr(HTTP_REQUEST);
        if (!(msg instanceof HttpRequest)) {
            Context serverContext = (Context)contextAttr.get();
            if (serverContext == null) {
                ctx.fireChannelRead(msg);
            } else {
                try (Scope ignored = serverContext.makeCurrent();){
                    ctx.fireChannelRead(msg);
                }
            }
            return;
        }
        Context parentContext = (Context)contextAttr.get();
        if (parentContext == null) {
            parentContext = Context.current();
        }
        if (!this.instrumenter.shouldStart(parentContext, (Object)(request = HttpRequestAndChannel.create((HttpRequest)((HttpRequest)msg), (Channel)channel)))) {
            ctx.fireChannelRead(msg);
            return;
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        contextAttr.set((Object)context);
        requestAttr.set((Object)request);
        try (Scope ignored = context.makeCurrent();){
            ctx.fireChannelRead(msg);
        }
        catch (Throwable throwable) {
            this.instrumenter.end((Context)contextAttr.getAndSet(null), (Object)((HttpRequestAndChannel)requestAttr.getAndSet(null)), null, throwable);
            throw throwable;
        }
    }
}

