/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1.internal.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.common.internal.NettyErrorHolder;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4_1.internal.AttributeKeys;
import io.opentelemetry.instrumentation.netty.v4_1.internal.server.HttpServerRequestTracingHandler;
import javax.annotation.Nullable;

public class HttpServerResponseTracingHandler
extends ChannelOutboundHandlerAdapter {
    static final AttributeKey<HttpResponse> HTTP_RESPONSE = AttributeKey.valueOf(HttpServerResponseTracingHandler.class, (String)"http-server-response");
    private final Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter;

    public HttpServerResponseTracingHandler(Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise prm) {
        ChannelPromise writePromise;
        Attribute contextAttr = ctx.channel().attr(AttributeKeys.SERVER_CONTEXT);
        Context context = (Context)contextAttr.get();
        if (context == null) {
            ctx.write(msg, prm);
            return;
        }
        if (msg instanceof LastHttpContent) {
            writePromise = prm.isVoid() ? ctx.newPromise() : prm;
            if (msg instanceof FullHttpResponse) {
                writePromise.addListener(future -> this.end(ctx.channel(), (HttpResponse)((FullHttpResponse)msg), (ChannelFuture)writePromise));
            } else {
                writePromise.addListener(future -> this.end(ctx.channel(), (HttpResponse)ctx.channel().attr(HTTP_RESPONSE).getAndSet(null), (ChannelFuture)writePromise));
            }
        } else {
            writePromise = prm;
            if (msg instanceof HttpResponse) {
                ctx.channel().attr(HTTP_RESPONSE).set((Object)((HttpResponse)msg));
            }
        }
        try (Scope ignored = context.makeCurrent();){
            ctx.write(msg, writePromise);
        }
        catch (Throwable throwable) {
            this.end(ctx.channel(), null, throwable);
            throw throwable;
        }
    }

    private void end(Channel channel, HttpResponse response, ChannelFuture future) {
        Throwable error = future.isSuccess() ? null : future.cause();
        this.end(channel, response, error);
    }

    private void end(Channel channel, @Nullable HttpResponse response, @Nullable Throwable error) {
        Context context = (Context)channel.attr(AttributeKeys.SERVER_CONTEXT).getAndSet(null);
        HttpRequestAndChannel request = (HttpRequestAndChannel)channel.attr(HttpServerRequestTracingHandler.HTTP_REQUEST).getAndSet(null);
        error = NettyErrorHolder.getOrDefault((Context)context, (Throwable)error);
        this.instrumenter.end(context, (Object)request, (Object)response, error);
    }
}

