/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1;

import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4_1.NettyServerTelemetryBuilder;
import io.opentelemetry.instrumentation.netty.v4_1.internal.server.HttpServerRequestTracingHandler;
import io.opentelemetry.instrumentation.netty.v4_1.internal.server.HttpServerResponseBeforeCommitHandler;
import io.opentelemetry.instrumentation.netty.v4_1.internal.server.HttpServerResponseTracingHandler;
import io.opentelemetry.instrumentation.netty.v4_1.internal.server.HttpServerTracingHandler;

public final class NettyServerTelemetry {
    private final Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter;

    NettyServerTelemetry(Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public static NettyServerTelemetry create(OpenTelemetry openTelemetry) {
        return NettyServerTelemetry.builder(openTelemetry).build();
    }

    public static NettyServerTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new NettyServerTelemetryBuilder(openTelemetry);
    }

    public ChannelInboundHandlerAdapter createRequestHandler() {
        return new HttpServerRequestTracingHandler(this.instrumenter);
    }

    public ChannelOutboundHandlerAdapter createResponseHandler() {
        return new HttpServerResponseTracingHandler(this.instrumenter, HttpServerResponseBeforeCommitHandler.Noop.INSTANCE);
    }

    public CombinedChannelDuplexHandler<? extends ChannelInboundHandlerAdapter, ? extends ChannelOutboundHandlerAdapter> createCombinedHandler() {
        return new HttpServerTracingHandler(this.instrumenter, HttpServerResponseBeforeCommitHandler.Noop.INSTANCE);
    }
}

