/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4.common.internal.server.NettyServerInstrumenterFactory;
import io.opentelemetry.instrumentation.netty.v4_1.NettyServerTelemetry;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class NettyServerTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private Consumer<HttpServerAttributesExtractorBuilder<HttpRequestAndChannel, HttpResponse>> extractorConfigurer = builder -> {};

    NettyServerTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public NettyServerTelemetryBuilder setCapturedRequestHeaders(List<String> capturedRequestHeaders) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setCapturedRequestHeaders(capturedRequestHeaders));
        return this;
    }

    @CanIgnoreReturnValue
    public NettyServerTelemetryBuilder setCapturedResponseHeaders(List<String> capturedResponseHeaders) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setCapturedResponseHeaders(capturedResponseHeaders));
        return this;
    }

    @CanIgnoreReturnValue
    public NettyServerTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setKnownMethods(knownMethods));
        return this;
    }

    public NettyServerTelemetry build() {
        return new NettyServerTelemetry((Instrumenter<HttpRequestAndChannel, HttpResponse>)NettyServerInstrumenterFactory.create((OpenTelemetry)this.openTelemetry, (String)"io.opentelemetry.netty-4.1", this.extractorConfigurer));
    }
}

