/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1.internal.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4_1.internal.AttributeKeys;
import io.opentelemetry.instrumentation.netty.v4_1.internal.client.HttpClientRequestTracingHandler;

public class HttpClientResponseTracingHandler
extends ChannelInboundHandlerAdapter {
    static final AttributeKey<HttpResponse> HTTP_CLIENT_RESPONSE = AttributeKey.valueOf(HttpClientResponseTracingHandler.class, (String)"http-client-response");
    private final Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter;

    public HttpClientResponseTracingHandler(Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpRequestAndChannel request;
        Attribute contextAttr = ctx.channel().attr(AttributeKeys.CLIENT_CONTEXT);
        Context context = (Context)contextAttr.get();
        if (context == null) {
            super.channelRead(ctx, msg);
            return;
        }
        Attribute parentContextAttr = ctx.channel().attr(AttributeKeys.CLIENT_PARENT_CONTEXT);
        Context parentContext = (Context)parentContextAttr.get();
        if (msg instanceof FullHttpResponse) {
            request = (HttpRequestAndChannel)ctx.channel().attr(HttpClientRequestTracingHandler.HTTP_CLIENT_REQUEST).getAndSet(null);
            this.instrumenter.end(context, (Object)request, (Object)((HttpResponse)msg), null);
            contextAttr.set(null);
            parentContextAttr.set(null);
        } else if (msg instanceof HttpResponse) {
            ctx.channel().attr(HTTP_CLIENT_RESPONSE).set((Object)((HttpResponse)msg));
        } else if (msg instanceof LastHttpContent) {
            request = (HttpRequestAndChannel)ctx.channel().attr(HttpClientRequestTracingHandler.HTTP_CLIENT_REQUEST).getAndSet(null);
            HttpResponse response = (HttpResponse)ctx.channel().attr(HTTP_CLIENT_RESPONSE).getAndSet(null);
            this.instrumenter.end(context, (Object)request, (Object)response, null);
            contextAttr.set(null);
            parentContextAttr.set(null);
        }
        if (parentContext != null) {
            try (Scope ignored = parentContext.makeCurrent();){
                super.channelRead(ctx, msg);
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }
}

