/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1.internal.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4_1.internal.AttributeKeys;
import io.opentelemetry.instrumentation.netty.v4_1.internal.ServerContext;
import java.util.ArrayDeque;
import java.util.Deque;

public class HttpServerRequestTracingHandler
extends ChannelInboundHandlerAdapter {
    private final Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter;

    public HttpServerRequestTracingHandler(Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpRequestAndChannel request;
        Channel channel = ctx.channel();
        Deque<ServerContext> serverContexts = HttpServerRequestTracingHandler.getOrCreate(channel, AttributeKeys.SERVER_CONTEXT);
        if (!(msg instanceof HttpRequest)) {
            ServerContext serverContext = serverContexts.peekLast();
            if (serverContext == null) {
                super.channelRead(ctx, msg);
            } else {
                try (Scope ignored = serverContext.context().makeCurrent();){
                    super.channelRead(ctx, msg);
                }
            }
            return;
        }
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)(request = HttpRequestAndChannel.create((HttpRequest)((HttpRequest)msg), (Channel)channel)))) {
            super.channelRead(ctx, msg);
            return;
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        serverContexts.addLast(ServerContext.create(context, request));
        try (Scope ignored = context.makeCurrent();){
            super.channelRead(ctx, msg);
        }
        catch (Throwable throwable) {
            ServerContext serverContext = serverContexts.removeLast();
            this.instrumenter.end(serverContext.context(), (Object)serverContext.request(), null, throwable);
            throw throwable;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ServerContext serverContext;
        Attribute contextAttr = ctx.channel().attr(AttributeKeys.SERVER_CONTEXT);
        Deque serverContexts = (Deque)contextAttr.get();
        if (serverContexts == null) {
            return;
        }
        while ((serverContext = (ServerContext)serverContexts.pollFirst()) != null) {
            this.instrumenter.end(serverContext.context(), (Object)serverContext.request(), null, null);
        }
    }

    private static <T> Deque<T> getOrCreate(Channel channel, AttributeKey<Deque<T>> key) {
        Attribute attribute = channel.attr(key);
        ArrayDeque deque = (ArrayDeque)attribute.get();
        if (deque == null) {
            deque = new ArrayDeque();
            attribute.set(deque);
        }
        return deque;
    }
}

