/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4_1.NettyClientTelemetryBuilder;
import io.opentelemetry.instrumentation.netty.v4_1.internal.AttributeKeys;
import io.opentelemetry.instrumentation.netty.v4_1.internal.client.HttpClientRequestTracingHandler;
import io.opentelemetry.instrumentation.netty.v4_1.internal.client.HttpClientResponseTracingHandler;
import io.opentelemetry.instrumentation.netty.v4_1.internal.client.HttpClientTracingHandler;

public final class NettyClientTelemetry {
    private final Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter;

    NettyClientTelemetry(Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public static NettyClientTelemetry create(OpenTelemetry openTelemetry) {
        return NettyClientTelemetry.builder(openTelemetry).build();
    }

    public static NettyClientTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new NettyClientTelemetryBuilder(openTelemetry);
    }

    public ChannelOutboundHandlerAdapter createRequestHandler() {
        return new HttpClientRequestTracingHandler(this.instrumenter);
    }

    public ChannelInboundHandlerAdapter createResponseHandler() {
        return new HttpClientResponseTracingHandler(this.instrumenter);
    }

    public CombinedChannelDuplexHandler<? extends ChannelInboundHandlerAdapter, ? extends ChannelOutboundHandlerAdapter> createCombinedHandler() {
        return new HttpClientTracingHandler(this.instrumenter);
    }

    public static void setChannelContext(Channel channel, Context context) {
        channel.attr(AttributeKeys.CLIENT_PARENT_CONTEXT).set((Object)context);
    }
}

