/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.net.PeerServiceResolver;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyClientInstrumenterFactory;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyConnectionInstrumentationFlag;
import io.opentelemetry.instrumentation.netty.v4_1.NettyClientTelemetry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class NettyClientTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<HttpRequestAndChannel, HttpResponse>> additionalAttributesExtractors = new ArrayList<AttributesExtractor<HttpRequestAndChannel, HttpResponse>>();
    private Consumer<HttpClientAttributesExtractorBuilder<HttpRequestAndChannel, HttpResponse>> extractorConfigurer = builder -> {};
    private Consumer<HttpSpanNameExtractorBuilder<HttpRequestAndChannel>> spanNameExtractorConfigurer = builder -> {};
    private boolean emitExperimentalHttpClientMetrics = false;

    NettyClientTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public NettyClientTelemetryBuilder setCapturedRequestHeaders(List<String> capturedRequestHeaders) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setCapturedRequestHeaders(capturedRequestHeaders));
        return this;
    }

    @CanIgnoreReturnValue
    public NettyClientTelemetryBuilder setCapturedResponseHeaders(List<String> capturedResponseHeaders) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setCapturedResponseHeaders(capturedResponseHeaders));
        return this;
    }

    @CanIgnoreReturnValue
    public NettyClientTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpRequestAndChannel, HttpResponse> attributesExtractor) {
        this.additionalAttributesExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public NettyClientTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setKnownMethods(knownMethods));
        this.spanNameExtractorConfigurer = this.spanNameExtractorConfigurer.andThen(builder -> builder.setKnownMethods(knownMethods));
        return this;
    }

    @CanIgnoreReturnValue
    public NettyClientTelemetryBuilder setEmitExperimentalHttpClientMetrics(boolean emitExperimentalHttpClientMetrics) {
        this.emitExperimentalHttpClientMetrics = emitExperimentalHttpClientMetrics;
        return this;
    }

    public NettyClientTelemetry build() {
        return new NettyClientTelemetry((Instrumenter<HttpRequestAndChannel, HttpResponse>)new NettyClientInstrumenterFactory(this.openTelemetry, "io.opentelemetry.netty-4.1", NettyConnectionInstrumentationFlag.DISABLED, NettyConnectionInstrumentationFlag.DISABLED, PeerServiceResolver.create(Collections.emptyMap()), this.emitExperimentalHttpClientMetrics).createHttpInstrumenter(this.extractorConfigurer, this.spanNameExtractorConfigurer, this.additionalAttributesExtractors));
    }
}

