/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1.internal.server;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.common.internal.NettyErrorHolder;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4_1.internal.AttributeKeys;
import io.opentelemetry.instrumentation.netty.v4_1.internal.ServerContext;
import io.opentelemetry.instrumentation.netty.v4_1.internal.server.HttpServerResponseBeforeCommitHandler;
import java.util.Deque;
import javax.annotation.Nullable;

public class HttpServerResponseTracingHandler
extends ChannelOutboundHandlerAdapter {
    private static final AttributeKey<HttpResponse> HTTP_SERVER_RESPONSE = AttributeKey.valueOf(HttpServerResponseTracingHandler.class, (String)"http-server-response");
    private final Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter;
    private final HttpServerResponseBeforeCommitHandler beforeCommitHandler;

    public HttpServerResponseTracingHandler(Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter, HttpServerResponseBeforeCommitHandler beforeCommitHandler) {
        this.instrumenter = instrumenter;
        this.beforeCommitHandler = beforeCommitHandler;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise prm) throws Exception {
        ChannelPromise writePromise;
        ServerContext serverContext;
        Attribute serverContextAttr = ctx.channel().attr(AttributeKeys.SERVER_CONTEXT);
        Deque serverContexts = (Deque)serverContextAttr.get();
        ServerContext serverContext2 = serverContext = serverContexts != null ? (ServerContext)serverContexts.peekFirst() : null;
        if (serverContext == null) {
            super.write(ctx, msg, prm);
            return;
        }
        if (msg instanceof LastHttpContent) {
            writePromise = prm.isVoid() ? ctx.newPromise() : prm;
            if (msg instanceof FullHttpResponse) {
                this.beforeCommitHandler.handle(serverContext.context(), (HttpResponse)msg);
                serverContexts.removeFirst();
                writePromise.addListener(future -> this.end(serverContext.context(), serverContext.request(), (HttpResponse)((FullHttpResponse)msg), (ChannelFuture)writePromise));
            } else {
                serverContexts.removeFirst();
                HttpResponse response = (HttpResponse)ctx.channel().attr(HTTP_SERVER_RESPONSE).getAndSet(null);
                writePromise.addListener(future -> this.end(serverContext.context(), serverContext.request(), response, (ChannelFuture)writePromise));
            }
        } else {
            writePromise = prm;
            if (msg instanceof HttpResponse) {
                this.beforeCommitHandler.handle(serverContext.context(), (HttpResponse)msg);
                ctx.channel().attr(HTTP_SERVER_RESPONSE).set((Object)((HttpResponse)msg));
            }
        }
        try (Scope ignored = serverContext.context().makeCurrent();){
            super.write(ctx, msg, writePromise);
        }
        catch (Throwable throwable) {
            serverContexts.removeFirst();
            this.end(serverContext.context(), serverContext.request(), null, throwable);
            throw throwable;
        }
    }

    private void end(Context context, HttpRequestAndChannel request, HttpResponse response, ChannelFuture future) {
        Throwable error = future.isSuccess() ? null : future.cause();
        this.end(context, request, response, error);
    }

    private void end(Context context, HttpRequestAndChannel request, @Nullable HttpResponse response, @Nullable Throwable error) {
        error = NettyErrorHolder.getOrDefault((Context)context, (Throwable)error);
        this.instrumenter.end(context, (Object)request, (Object)response, error);
    }
}

