/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.tracer.HttpClientTracer;
import io.opentelemetry.instrumentation.okhttp.v3_0.RequestBuilderInjectAdapter;
import java.net.URI;
import okhttp3.Request;
import okhttp3.Response;

final class OkHttpClientTracer
extends HttpClientTracer<Request, Request.Builder, Response> {
    OkHttpClientTracer(OpenTelemetry openTelemetry) {
        super(openTelemetry);
    }

    protected String method(Request httpRequest) {
        return httpRequest.method();
    }

    protected URI url(Request httpRequest) {
        return httpRequest.url().uri();
    }

    protected Integer status(Response httpResponse) {
        return httpResponse.code();
    }

    protected String requestHeader(Request request, String name) {
        return request.header(name);
    }

    protected String responseHeader(Response response, String name) {
        return response.header(name);
    }

    protected TextMapSetter<Request.Builder> getSetter() {
        return RequestBuilderInjectAdapter.SETTER;
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.javaagent.okhttp-3.0";
    }
}

