/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.okhttp.v3_0.OkHttpClientTracer;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

final class TracingInterceptor
implements Interceptor {
    private final OkHttpClientTracer tracer;

    TracingInterceptor(OkHttpClientTracer tracer) {
        this.tracer = tracer;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Context parentContext = Context.current();
        if (!this.tracer.shouldStartSpan(parentContext)) {
            return chain.proceed(chain.request());
        }
        Request.Builder requestBuilder = chain.request().newBuilder();
        Context context = this.tracer.startSpan(parentContext, chain.request(), requestBuilder);
        try (Scope ignored = context.makeCurrent();){
            response = chain.proceed(requestBuilder.build());
        }
        catch (Exception e) {
            this.tracer.endExceptionally(context, e);
            throw e;
        }
        this.tracer.end(context, response);
        return response;
    }
}

