/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientRequestResendCount;
import io.opentelemetry.instrumentation.okhttp.v3_0.TracingCallFactory;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

final class ContextInterceptor
implements Interceptor {
    ContextInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Context parentContext = TracingCallFactory.getCallingContextForRequest(request);
        if (parentContext == null) {
            parentContext = Context.current();
        }
        Context context = HttpClientRequestResendCount.initialize((Context)parentContext);
        try (Scope ignored = context.makeCurrent();){
            Response response = chain.proceed(request);
            return response;
        }
    }
}

