/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.okhttp.v3_0.internal.RequestHeaderSetter;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class TracingInterceptor
implements Interceptor {
    private final Instrumenter<Interceptor.Chain, Response> instrumenter;
    private final ContextPropagators propagators;

    public TracingInterceptor(Instrumenter<Interceptor.Chain, Response> instrumenter, ContextPropagators propagators) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)chain)) {
            return chain.proceed(chain.request());
        }
        Context context = this.instrumenter.start(parentContext, (Object)chain);
        request = this.injectContextToRequest(request, context);
        try (Scope ignored = context.makeCurrent();){
            response = chain.proceed(request);
        }
        catch (Throwable t) {
            this.instrumenter.end(context, (Object)chain, null, t);
            throw t;
        }
        this.instrumenter.end(context, (Object)chain, (Object)response, null);
        return response;
    }

    private Request injectContextToRequest(Request request, Context context) {
        Request.Builder requestBuilder = request.newBuilder();
        this.propagators.getTextMapPropagator().inject(context, (Object)requestBuilder, (TextMapSetter)RequestHeaderSetter.INSTANCE);
        return requestBuilder.build();
    }
}

